/** 
 * \file EditorManager.h
 * \brief CEditorManager class is the boss. The manager. It creates 3D device (irrlicht of course),
 * creates GUI, and 3D environment so called Level Editor. Calls all the initialization functions and 
 * goes to the loop.
 * 
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_GAMEMANAGER_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_GAMEMANAGER_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_


#include <irrlicht.h>
#include "level/EDLevel.h"
#include "gui/EDGui.h"
#include "Script.h"

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

/**
 * \brief CEditorManager class is the boss. The manager. It creates 3D device (irrlicht of course),
 * creates GUI, and 3D environment so called Level Editor. Calls all the initialization functions and 
 * goes to the loop.
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CEditorManager : public IEventReceiver
{
public:
	CEditorManager();
	~CEditorManager();
	void Update();
	void Init();
	IrrlichtDevice* getDevice();
	IVideoDriver* getDriver();
	ISceneManager* getSceneMngr();
	IGUIEnvironment* getGUIEnvironment();
	CEditorGUI* getGUIManager() {return m_pGuiManager;}
	CEditorLevel* getEdiLevel() {return m_pEdiLevel;}
	CScript* getScriptEngine() {return m_ScriptEngine;}
	IFileSystem* getFS() {return m_FS;}
	void backToWorkingDirectory();
	virtual bool OnEvent(const SEvent& event);

	s32 m_ID;

protected:
	

private:
	void CreateDevice();
	IrrlichtDevice* m_pDevice;  
	IVideoDriver* m_pDriver;
	ISceneManager* m_pSceneManager;
    IGUIEnvironment* m_pGUIEnvironment; //irrlichts default gui environment
	IFileSystem* m_FS;
	stringc m_WorkingDirectory;

	CEditorGUI* m_pGuiManager; //our homemade gui manager
	CEditorLevel* m_pEdiLevel;
	CScript* m_ScriptEngine;
	/*irr::gui::IGUIFont* m_pFont;*/
	
	int lastFPS;
};
#endif

