/** 
 * \file Script.cpp
 * \brief CScript class is the boss. The manager. It creates 3D device (irrlicht of course),
 * creates GUI, and 3D environment so called Level Editor. Calls all the initialization functions and 
 * goes to the loop.
 * 
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
using namespace irr;
using namespace io;
#include "Script.h"

/**
 * \brief Standard constructor.
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
CScript::CScript()
{
	
}

/**
 * \brief Standard destructor.
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
CScript::~CScript()
{
}

/**
 * \brief Initialization function. Loads script actions from given XML file.
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
bool CScript::Init(IrrlichtDevice* device, stringc filename)
{
	IFileSystem* fs = device->getFileSystem();
	IXMLReader* xml = fs->createXMLReader(filename.c_str());
	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case EXN_ELEMENT:
			{
				if (stringw("ScriptActions") != xml->getNodeName())
				{
					stringw figo = xml->getNodeName();
					m_ListOfScriptActions.push_back(figo.c_str());
				}
			}
		}
	}
	return true;
}

stringw CScript::GetActionLine(TAction action)
{
	stringw script = "<";
	script += action.name;
	script += " target=\"";
	script += action.target;
	script += "\" attribute=\"";
	script += action.attribute;
	script += "\" value=\"";
	script += action.value;
	script += "\" />\n";
	return script;
}