/** 
 * \file EDGui.h
 * \brief Header file containing CEditorGUI class used for managing GUI action.
 * CEditorGUI class creates menus and property windows and buttons and handles all the user clicks.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_EDGUICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_EDGUICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_

#include <irrlicht.h>
#include "GUIWndMaker.h"
#include "IGUITreeCtrl.h"

class CEditorManager;
class CPickableItem;

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

/**
 * \brief TAnimationRanges is struct describing animated object animation frames.
 * Animated character usually has standard animations like Walk, Idle, Attack, Run, Sleep...
 * \author Petar Bajic \date July, 21 2008.
 */typedef struct S_AnimationRanges
{
	u32 StartFrameWalk;
	u32 EndFrameWalk;
	u32 StartFrameRun;
	u32 EndFrameRun;
	u32 StartFrameIdle;
	u32 EndFrameIdle;
	u32 StartFrameAttack;
	u32 EndFrameAttack;
	//add more attacks and other animations here :)
} TAnimationRanges;

/**
 * \brief TGameObjectProperty is struct describing game object properties.
 * Standard irrlicht scene node attributes are expanded with few properties like: isContainer, isPickable...
 * \author Petar Bajic \date July, 21 2008.
 */
typedef struct S_GameObjectProperty
{
	stringw name;
	stringw mesh;
	stringw position;
	bool isContainer;
	bool isVisible;
	bool isPickable;
	bool isTrigger;
	bool isNPC;
	bool isMonster;
	stringw description;
	stringw script;
	TAnimationRanges anim;
	u32 id;

} TGameObjectProperty;

/**
 * \brief CEditorGUI class creates menus and property windows and buttons and handles all the user clicks.
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CEditorGUI
{
public:
	CEditorGUI();
	~CEditorGUI();
	bool Init(CEditorManager* edMngr);
	void SetProperties(TGameObjectProperty properties);
	void SetPosition(stringw position);
	void ClearProperties();
	void SetElementAtHand(stringw parent, stringw name);
	void SendModelToPhotoSession(stringw parent, stringw name);
	void SendModelToPickSession(stringw parent, stringw name);
	stringw getRootNameFromPath(stringw path);
	void SetIconAtHand(stringw parent, stringw name);
	void WritePickScript(s32 index);
	void WriteTriggerScript(s32 index);
	void WriteNPCDialogScriptAction();
	void SavePickScript(stringc file);
	void SaveTriggerScript(stringc file);
	void WriteElement(IXMLWriter* xml, TreeNode* node);
	void CheckDialogNodeActions(TreeNode* node, u32 deletedNodeID);
	void SaveDialog(stringc file);
	bool OnEvent(const SEvent& event);

	CEditorManager* m_EditorManager;

	//Gui manager has a lot of pointers to gui elements:

	//properties window gui elements
	IGUIEditBox* m_PropEditBox_Name;
	IGUIEditBox* m_PropEditBox_Pos;
	IGUIEditBox* m_PropEditBox_Model;
	IGUIEditBox* m_PropEditBox_ID;
	IGUIEditBox* m_PropEditBox_Description;
	IGUIComboBox* m_PropComboBox_Visible;
	IGUIComboBox* m_PropComboBox_Container;
	IGUIComboBox* m_PropComboBox_Pickable;
	IGUIComboBox* m_PropComboBox_Trigger;
	IGUIComboBox* m_PropComboBox_NPC;
	IGUIComboBox* m_PropComboBox_Monster;
	IGUIButton* m_ContainerButton;
	IGUIButton* m_PickScriptButton;
	IGUIButton* m_TriggerScriptButton;
	IGUIButton* m_NPCScriptButton;
	IGUIButton* m_MonsterScriptButton;

	//pick script widow gui elements
	IGUIListBox* m_PickListBox_ExistingEvents;
	IGUICheckBox* m_PickCheckBox_Equipable;
	IGUICheckBox* m_PickCheckBox_Usable;
	IGUIComboBox* m_PickComboBox_Actions;
	IGUIComboBox* m_PickComboBox_Events;
	IGUIComboBox* m_PickComboBox_EventTarget;
	IGUIComboBox* m_PickComboBox_ActionTarget;
	IGUIEditBox* m_PickEditBox_ActionTargetID;
	IGUIEditBox* m_PickEditBox_ActionAttribute;
	IGUIEditBox* m_PickEditBox_ActionValue;
	IGUIEditBox* m_PickEditBox_Script;
	IGUIButton* m_PickButton_AddAction;
	IGUIButton* m_PickButton_AddEvent;
	IGUIButton* m_PickButton_RemoveEvent;
	IGUIButton* m_PickButton_Save;
	IGUIButton* m_PickButton_Cancel;

	//Trigger script window
	IGUIListBox* m_TriggerListBox_States;
	IGUIEditBox* m_TriggerEditBox_State;
	IGUIButton* m_TriggerButton_AddState;
	IGUIButton* m_TriggerButton_RemoveState;
	IGUIButton* m_TriggerButton_SetState;

	//dialog
	IGUIEditBox* m_DialogEditBox_Text;
	IGUIEditBox* m_DialogEditBox_SelectedNodeID;
	IGUIEditBox* m_DialogEditBox_ChangeText;
	IGUIEditBox* m_DialogEditBox_Answer;
	IGUIEditBox* m_DialogEditBox_ActionsText;
	IGUIEditBox* m_DialogEditBox_ActionAttribute;
	IGUIEditBox* m_DialogEditBox_ActionValue;
	IGUIEditBox* m_DialogEditBox_ActionTargetID;
	IGUIComboBox* m_DialogComboBox_Actions;
	IGUIComboBox* m_DialogComboBox_ActionTarget;
	IGUIComboBox* m_DialogComboBox_Conditions;
	IGUIButton* m_DialogButton_AddNode;
	IGUIButton* m_DialogButton_RemoveNode;
	IGUIButton* m_DialogButton_LinkNodes;
	IGUIButton* m_DialogButton_ToggleEnabled;
	IGUIButton* m_DialogButton_ChangeText;
	IGUIButton* m_DialogButton_AddAction;
	IGUIButton* m_DialogButton_ClearAction;
	IGUIButton* m_DialogButton_AddCondition;
	IGUIButton* m_DialogButton_Ok;
	IGUIButton* m_DialogButton_Cancel;
	IGUIButton* m_DialogButton_AddText;
	IGUIButton* m_DialogButton_Warning;
	IGUITreeCtrl* m_DialogTree;
	TreeNode *m_SelectedNode;
	u32 m_NumNodes;
	bool m_bLinkDialogNodes;
	stringc m_DialogFilename;

	//windows
	IGUIWindow* m_wnd_gameItems;
	IGUIWindow* m_wnd_properties;
	IGUIWindow* m_wnd_containerContent;
	IGUIWindow* m_wnd_AddNPCScriptAction;
	IGUIWindow* m_wnd_AddNPCNewText;
	IGUIWindow* m_wnd_AddPickScriptAction;
	IGUIWindow* m_wnd_AddTriggerScriptAction;
	IGUIWindow* m_wnd_ModelPreview;
	
	s32 m_SelectedObjectID;
	stringw m_PickScript;

	IGUITabControl* m_tabGameObjects;

	bool m_bFileSaveDialog;
	bool m_bFileOpenDialog;
	bool m_bElementPicking;
	bool m_bAddPickDirectly;

	//container GUI
	IGUICheckBox* m_PickCheckBox_DirectPick;
	IGUIButton* m_pContainer_Ok;
	IGUIButton* m_pContainer_EditPickItemScript;
	IGUIButton* m_pContainer_AddPickItemToContainer;
	IGUIStaticText* m_pPickPreviewDescriptionText;
	ITexture* m_slotTex;
	ITexture* m_SelectedPickItemIcon_Texture;
	ITexture* m_ContainerPickPreview_TextureToRenderOn;
	ICameraSceneNode* m_PickCamera;
	CPickableItem* m_pPreviewPickableItem;

	//Model Preview window
	ICameraSceneNode* m_PhotoCamera;
	ITexture* m_TextureToRenderOn;
	IGUIStaticText* m_pPreviewDescriptionText;
};

#endif

