/** 
 * \file GUIWndMaker.cpp
 * \brief Creating floating and various dialog windows for GUI class
 * 
 * Who says it all has to be in one cpp file? :) 
 * I moved these functions from EDGui.cpp file, CEditorGUI class, to stop it from growing enormous
 * All funtions that create some kind of GUI window are neatly placed here.
 * Writting a winning combination of include files was a nigthmare but I did it!
 * Couldn't repeat it if I wanted to, so don't touch anything :)
 * 
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */
#include "GUIWndMaker.h"
#include "IGUITreeCtrl.h"
#include "IGUIContainer.h"

#include "../EditorManager.h"

typedef struct SDialogNode
{
	int id;
	stringw name;
	stringw text;
	stringw speaker;

}TDialogNode;

//helper function that populates TreeNode with data from XML file, used in more then one window creation
void PopulateTreeNodeFromXML(IGUIEnvironment* env, IrrlichtDevice* device, stringc dir_filename, IGUIElement *parent, core::rect<s32> position, s32 id)
{
	/*Fill Tree*/
	stringw temp = dir_filename.c_str(); //dir filename is also xml filename, and is also xml element name.
	stringc xml_filename = dir_filename + ".xml";
	int NUM_NODES = 100;
	IGUITreeCtrl *tree = AddGUITreeCtrl(env, position, parent, id, false);
	gui::TreeNode **NodeList = new gui::TreeNode*[NUM_NODES];
	NodeList[0] = tree->GetRootNode();
	io::IXMLReader* xml = device->getFileSystem()->createXMLReader(xml_filename.c_str());
	int nb_node = 1;
	int parent_node = 0;
	/*Don't ask how this tree populating from xml structure works. I did it, but I still can't figure out how.*/
	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case io::EXN_ELEMENT:
			{
				stringw figo;
				if (temp == xml->getNodeName())
				{
					figo = xml->getAttributeValue(L"filename");
					NodeList[nb_node] = tree->InsertNode(figo.c_str(),NodeList[parent_node],nb_node);
					nb_node++;
				}
				else if (core::stringw("Config") == xml->getNodeName())
				{
					//doing nothing for config
				}
				else
				{
					//New Folder, create node and step in.
					figo = xml->getNodeName();
					NodeList[nb_node] = tree->InsertNode(figo.c_str(),NodeList[parent_node],nb_node);
					parent_node = nb_node;
					nb_node++;
				}
			}
			break;
		case io::EXN_ELEMENT_END:
			{
				stringw newre = xml->getNodeName();
				if (core::stringw("Config") != newre)
				{
					//Folder Closed, stepping out.
					parent_node = 0;
				}
			}
			break;
		}
	}

	if (xml)
		xml->drop(); // don't forget to delete the xml reader
}

//helper function that populates TreeNode with data from dialog XML file
void PopulateDialogTreeNodeFromXML(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, stringc filename, IGUIElement *parent, core::rect<s32> position)
{
	/*Fill Tree*/
	int NUM_NODES = 100;
	editorManager->getGUIManager()->m_DialogTree = AddGUITreeCtrl(env, position, parent, 714, true);
	gui::TreeNode **NodeList = new gui::TreeNode*[NUM_NODES];
	u32 Parenthood[100];
	NodeList[0] = editorManager->getGUIManager()->m_DialogTree->GetRootNode();
	int nodeIndex = 0;
	int nodeParent = 0;
	int lastParentNode = nodeParent;
	bool first = true;
	int ParenthoodDepth = 0;
	Parenthood[ParenthoodDepth] = 0;
	bool loadingAction = false;

	editorManager->getGUIManager()->m_NumNodes = 0;

	//stringc xml_filename = filename + ".xml";
	io::IXMLReader* xml = device->getFileSystem()->createXMLReader(filename.c_str());

	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case io::EXN_ELEMENT:
			{
				stringw figo;
				//Insert New Node
				if (stringw(L"Node") == xml->getNodeName())
				{
					nodeIndex++;
					NodeList[nodeIndex] = editorManager->getGUIManager()->m_DialogTree->InsertNode(L"node",NodeList[Parenthood[ParenthoodDepth]],nodeIndex);
					ParenthoodDepth++;
					Parenthood[ParenthoodDepth] = nodeIndex;
				}
				//InsertAllData
				else if (stringw(L"Id") == xml->getNodeName())
				{
					u32 id = xml->getAttributeValueAsInt(L"value");
					NodeList[Parenthood[ParenthoodDepth]]->ID = id;
					if(id > editorManager->getGUIManager()->m_NumNodes)
					{
						editorManager->getGUIManager()->m_NumNodes = id;
					}
				}
				else if (stringw(L"Enabled") == xml->getNodeName())
				{
					if(stringw(L"true") == xml->getAttributeValue(L"value"))
					{
						NodeList[Parenthood[ParenthoodDepth]]->isEnabled = true;
					}
					else
					{
						NodeList[Parenthood[ParenthoodDepth]]->isEnabled = false;
					}
				}
				else if (stringw(L"Link") == xml->getNodeName())
				{
					NodeList[Parenthood[ParenthoodDepth]]->LinkID = xml->getAttributeValueAsInt(L"value");
				}
				else if (stringw(L"IsLink") == xml->getNodeName())
				{
					if(stringw(L"true") == xml->getAttributeValue(L"value"))
					{
						NodeList[Parenthood[ParenthoodDepth]]->isLink = true;
					}
					else
					{
						NodeList[Parenthood[ParenthoodDepth]]->isLink = false;
					}
				}
				else if (stringw(L"Speaker") == xml->getNodeName())
				{
					NodeList[Parenthood[ParenthoodDepth]]->NPCName = xml->getAttributeValue(L"value");
					if (stringw(L"PLAYER") == NodeList[Parenthood[ParenthoodDepth]]->NPCName)
						NodeList[Parenthood[ParenthoodDepth]]->Player = true;
					else
						NodeList[Parenthood[ParenthoodDepth]]->Player = false;
				}
				else if (stringw(L"Text") == xml->getNodeName())
				{
					NodeList[Parenthood[ParenthoodDepth]]->Text = xml->getAttributeValue(L"value");
				}
				else if (stringw(L"Actions") == xml->getNodeName())
				{
					NodeList[Parenthood[ParenthoodDepth]]->scriptAction.actions.clear();
					loadingAction = true;
				}
				else if (loadingAction)
				{
					TAction action;
					action.name = xml->getNodeName();
					action.target = xml->getAttributeValue(L"target");
					action.attribute = xml->getAttributeValue(L"attribute");
					action.value = xml->getAttributeValue(L"value");
					NodeList[Parenthood[ParenthoodDepth]]->scriptAction.actions.push_back(action);
					NodeList[Parenthood[ParenthoodDepth]]->hasScriptAction = true;
				}

			}
			break;
		case io::EXN_ELEMENT_END:
			{
				if (stringw(L"Node") == xml->getNodeName())
				{
					//Node Closed, stepping out.
					ParenthoodDepth--;
				}
				else if (stringw(L"Actions") == xml->getNodeName())
				{
					loadingAction = false;
				}

			}
			break;
		}
	}

	if (xml)
		xml->drop(); // don't forget to delete the xml reader

	if(nodeIndex == 0)
	{
		NodeList[1] = editorManager->getGUIManager()->m_DialogTree->InsertNode(L"node",NodeList[0],1);
		NodeList[1]->isEnabled = true;
		NodeList[1]->Child = 0;
		NodeList[1]->hasScriptAction = false;
		NodeList[1]->IconClosed = true;
		NodeList[1]->ID = 1;
		NodeList[1]->isLink = false;
		NodeList[1]->Link = 0;
		NodeList[1]->NPCName = L"RootNode";
		NodeList[1]->Player = true;
		NodeList[1]->Text = L"RootNode";
		NodeList[1]->scriptAction.actions.clear();
		editorManager->getGUIManager()->m_NumNodes = 1;
	}
	else
	{
		//Go through the list and Link nodes
		for(u32 a=0; a<(u32)nodeIndex; a++)
		{
			//find link nodes
			if(NodeList[a]->LinkID != 0)
			{
				for(u32 b=0; b<(u32)nodeIndex; b++)
				{
					if(NodeList[b]->ID == NodeList[a]->LinkID)
					{
						NodeList[a]->Link = NodeList[b];
						break;
					}
				}
			}
		}
	}
}

//Initialize game objects window and feed tab control with existing models (search directory structure)
IGUIWindow* MakeGameObjectsWindow(IGUIEnvironment* env, IrrlichtDevice* device)
{
	/*Game Items window*/
	IGUIWindow* wnd_gameItems = env->addWindow(core::rect<s32>(0,30,230,400), false, L"Game Objects", 0, 4000);
	wnd_gameItems->setToolTipText(L"Select item from tree and then place it on the map.");

	// create tab control and tabs
	IGUITabControl* tabGameObjects = env->addTabControl(core::rect<s32>(2,20,220,470), wnd_gameItems, true, true, 6000);

	IFileSystem* fs = device->getFileSystem();
	IFileList* filelist = NULL;
	fs->changeWorkingDirectoryTo("media/GameObjects");
	filelist = fs->createFileList();
	IGUITab* tabs[10]; int ir = 0;
	for ( u32 a = 2; a < filelist->getFileCount(); a++)
	{
		if(filelist->isDirectory(a))
		{
			stringw temp = filelist->getFileName(a);
			stringc dir_filename = temp.c_str();
			fs->changeWorkingDirectoryTo(dir_filename.c_str());
			tabs[ir] = tabGameObjects->addTab(temp.c_str());
			PopulateTreeNodeFromXML(env, device, dir_filename,tabs[ir],core::rect<s32>(5,5,170,320),6000+a);
			fs->changeWorkingDirectoryTo("../");
			ir++;
		}
	}
	fs->changeWorkingDirectoryTo("../../");
	filelist->drop();
	return wnd_gameItems;
}

//creates window that allows user to add content to container
IGUIWindow* MakeContainerContentWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id)
{
	s32 centerX = device->getVideoDriver()->getScreenSize().Width/2;
	s32 centerY = device->getVideoDriver()->getScreenSize().Height/2;

	IGUIWindow* wnd_containerContent = env->addWindow(core::rect<s32>(centerX-275,centerY-200,centerX+275,centerY+200), false, L"Container Content", 0, 1360);
	IFileSystem* fs = device->getFileSystem();
	fs->changeWorkingDirectoryTo("media/GameObjects/Pickables");
	IGUITabControl* tabPickables = env->addTabControl(core::rect<s32>(2,20,110,377), wnd_containerContent, true, true);
	IGUITab* tab = tabPickables->addTab(L"Pickables");
	PopulateTreeNodeFromXML(env, device, stringc("Pickables"),tab,core::rect<s32>(5,2,100,320),6100);
	editorManager->getGUIManager()->m_PickCheckBox_DirectPick = editorManager->getGUIEnvironment()->addCheckBox(false, core::rect<int>(200,235,300,250), wnd_containerContent, 1362, L"Add item on select");
	editorManager->getGUIManager()->m_pContainer_AddPickItemToContainer = env->addButton(core::rect<s32>(200,255,280,285), wnd_containerContent, 1363, L"Add Item >>");
	editorManager->getGUIEnvironment()->addStaticText(L"Preview:", core::rect<s32>(120,25,300,35), false, false, wnd_containerContent, 1364, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Description:", core::rect<s32>(120,300,300,310), false, false, wnd_containerContent, 1365, false);
	editorManager->getGUIManager()->m_pPickPreviewDescriptionText = editorManager->getGUIEnvironment()->addStaticText(L"No description.", core::rect<s32>(120,315,300,355), true, true, wnd_containerContent, 1366, false);
	editorManager->getGUIManager()->m_pContainer_EditPickItemScript = env->addButton(core::rect<s32>(150,365,240,385), wnd_containerContent, 1361, L"Edit Pick Script");
	editorManager->getGUIManager()->m_pContainer_Ok = env->addButton(core::rect<s32>(360,360,440,380), wnd_containerContent, 1367, L"Ok");
	fs->changeWorkingDirectoryTo("../../../");

	//init GUI state
	editorManager->getGUIManager()->m_pPreviewPickableItem = 0;
	editorManager->getGUIManager()->m_PickCheckBox_DirectPick->setChecked(editorManager->getGUIManager()->m_bAddPickDirectly);
	editorManager->getGUIManager()->m_pContainer_AddPickItemToContainer->setEnabled(false);
	editorManager->getGUIManager()->m_pContainer_EditPickItemScript->setEnabled(false);

	//remove preview object
	editorManager->getEdiLevel()->RemovePickSessionModel();
	editorManager->getGUIManager()->m_SelectedPickItemIcon_Texture = 0;

	//Get empty Slot texture
	editorManager->getGUIManager()->m_slotTex = env->getVideoDriver()->getTexture("media/Icons/slot.png");
	//Load Container
	IGUIContainer* container = AddGUIContainer(
		env,
		core::rect<s32>(330,40,525,330), 
		wnd_containerContent, 
		1357,
		core::dimension2d<s32>(3,3),
		core::dimension2d<s32>(1,1),
		editorManager->getGUIManager()->m_slotTex
		);

	//Load Existing Container Content (if any)
	s32 numberOfItems = editorManager->getEdiLevel()->m_ListOfGameObjects[id]->GetNumberOfPickableItems();
	for(int i = 0; i<numberOfItems; i++)
	{
		//Add this element
		stringc iconPath = editorManager->getEdiLevel()->m_ListOfGameObjects[id]->GetPickableItem(i);
		CPickableItem* item = new CPickableItem();
		item->setName(iconPath.c_str());
		item->m_IconTexture = env->getVideoDriver()->getTexture(iconPath.c_str());
		container->InsertItem(item);
	}

	return wnd_containerContent;
}

/*Creates Properties window that displays properties of selected game object and lets you edit them*/
IGUIWindow* MakePropertiesWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device)
{
	s32 rightX = device->getVideoDriver()->getScreenSize().Width;

	IGUIWindow* wnd_properties = editorManager->getGUIEnvironment()->addWindow(core::rect<s32>(rightX-200,14,rightX,480), false, L"Object Properties", 0, 5000);
	wnd_properties->setToolTipText(L"Properties of selected game object");

	editorManager->getGUIEnvironment()->addStaticText(L"Name", core::rect<s32>(10,40,50,60), false, false, wnd_properties, 1102, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Position", core::rect<s32>(10,60,50,80), false, false, wnd_properties, 1103, false);
	editorManager->getGUIEnvironment()->addStaticText(L"model file", core::rect<s32>(10,80,50,100), false, false, wnd_properties, 1104, false);
	editorManager->getGUIEnvironment()->addStaticText(L"id", core::rect<s32>(10,100,50,120), false, false, wnd_properties, 1105, false);
	editorManager->getGUIEnvironment()->addStaticText(L"visible", core::rect<s32>(10,120,50,140), false, false, wnd_properties, 1106, false);
	editorManager->getGUIEnvironment()->addStaticText(L"container", core::rect<s32>(10,140,50,160), false, false, wnd_properties, 1107, false);
	editorManager->getGUIEnvironment()->addStaticText(L"content", core::rect<s32>(10,160,50,180), false, false, wnd_properties, 1108, false);
	editorManager->getGUIEnvironment()->addStaticText(L"pickable", core::rect<s32>(10,180,50,200), false, false, wnd_properties, 1109, false);
	editorManager->getGUIEnvironment()->addStaticText(L"script", core::rect<s32>(10,200,50,220), false, false, wnd_properties, 1110, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Trigger", core::rect<s32>(10,220,50,240), false, false, wnd_properties, 1111, false);
	editorManager->getGUIEnvironment()->addStaticText(L"script", core::rect<s32>(10,240,50,260), false, false, wnd_properties, 1112, false);
	editorManager->getGUIEnvironment()->addStaticText(L"NPC", core::rect<s32>(10,260,50,280), false, false, wnd_properties, 1113, false);
	editorManager->getGUIEnvironment()->addStaticText(L"script", core::rect<s32>(10,280,50,300), false, false, wnd_properties, 1114, false);
	editorManager->getGUIEnvironment()->addStaticText(L"monster", core::rect<s32>(10,300,50,320), false, false, wnd_properties, 1115, false);
	editorManager->getGUIEnvironment()->addStaticText(L"script", core::rect<s32>(10,320,50,340), false, false, wnd_properties, 1116, false);
	editorManager->getGUIManager()->m_PropEditBox_Name = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(50,35,150,55), true, wnd_properties, 1201);
	editorManager->getGUIManager()->m_PropEditBox_Pos = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(50,55,150,75), true, wnd_properties, 1202);
	editorManager->getGUIManager()->m_PropEditBox_Model = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(50,75,150,95), true, wnd_properties, 1203);
	editorManager->getGUIManager()->m_PropEditBox_ID = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(50,95,150,115), true, wnd_properties, 1204);
	editorManager->getGUIManager()->m_PropEditBox_ID->setEnabled(false);
	editorManager->getGUIManager()->m_PropComboBox_Visible = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(50,115,150,135), wnd_properties, 1205);
	editorManager->getGUIManager()->m_PropComboBox_Visible->addItem(L"true");
	editorManager->getGUIManager()->m_PropComboBox_Visible->addItem(L"false");
	editorManager->getGUIManager()->m_PropComboBox_Visible->setSelected(1);
	editorManager->getGUIManager()->m_PropComboBox_Container = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(50,135,150,155), wnd_properties, 1206);
	editorManager->getGUIManager()->m_PropComboBox_Container->addItem(L"true");
	editorManager->getGUIManager()->m_PropComboBox_Container->addItem(L"false");
	editorManager->getGUIManager()->m_PropComboBox_Container->setSelected(1);
	editorManager->getGUIManager()->m_ContainerButton = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(50,155,150,175), wnd_properties, 1192, L"Add Container Content");
	editorManager->getGUIManager()->m_ContainerButton->setEnabled(false);

	editorManager->getGUIManager()->m_PropComboBox_Pickable = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(50,175,150,195), wnd_properties, 1208);
	editorManager->getGUIManager()->m_PropComboBox_Pickable->addItem(L"true");
	editorManager->getGUIManager()->m_PropComboBox_Pickable->addItem(L"false");
	editorManager->getGUIManager()->m_PropComboBox_Pickable->setSelected(1);
	editorManager->getGUIManager()->m_PickScriptButton = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(50,195,150,215), wnd_properties, 1209, L"Add Pick Script");
	editorManager->getGUIManager()->m_PickScriptButton->setEnabled(false);

	editorManager->getGUIManager()->m_PropComboBox_Trigger = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(50,215,150,235), wnd_properties, 1210);
	editorManager->getGUIManager()->m_PropComboBox_Trigger->addItem(L"true");
	editorManager->getGUIManager()->m_PropComboBox_Trigger->addItem(L"false");
	editorManager->getGUIManager()->m_PropComboBox_Trigger->setSelected(1);
	editorManager->getGUIManager()->m_TriggerScriptButton = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(50,235,150,255), wnd_properties, 1211, L"Trigger Script Action");
	editorManager->getGUIManager()->m_TriggerScriptButton->setEnabled(false);

	editorManager->getGUIManager()->m_PropComboBox_NPC = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(50,255,150,275), wnd_properties, 1212);
	editorManager->getGUIManager()->m_PropComboBox_NPC->addItem(L"true");
	editorManager->getGUIManager()->m_PropComboBox_NPC->addItem(L"false");
	editorManager->getGUIManager()->m_PropComboBox_NPC->setSelected(1);
	editorManager->getGUIManager()->m_NPCScriptButton = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(50,275,150,295), wnd_properties, 1213, L"NPC Script Action");
	editorManager->getGUIManager()->m_NPCScriptButton->setEnabled(false);

	editorManager->getGUIManager()->m_PropComboBox_Monster = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(50,295,150,315), wnd_properties, 1214);
	editorManager->getGUIManager()->m_PropComboBox_Monster->addItem(L"true");
	editorManager->getGUIManager()->m_PropComboBox_Monster->addItem(L"false");
	editorManager->getGUIManager()->m_PropComboBox_Monster->setSelected(1);
	editorManager->getGUIManager()->m_MonsterScriptButton = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(50,315,150,335), wnd_properties, 1215, L"Monster Script");
	editorManager->getGUIManager()->m_MonsterScriptButton->setEnabled(false);

	editorManager->getGUIEnvironment()->addStaticText(L"Description:", core::rect<s32>(10,340,150,360), false, false, wnd_properties, 1117, false);
	editorManager->getGUIManager()->m_PropEditBox_Description = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(10,360,150,430), true, wnd_properties, 1216);
	editorManager->getGUIManager()->m_PropEditBox_Description->setMultiLine(true);
	editorManager->getGUIManager()->m_PropEditBox_Description->setWordWrap(true);

	IGUIButton* but = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(80,440,120,460), wnd_properties, 1101, L"Set");

	return wnd_properties;
}

//creates window that allows user to add content to container
IGUIWindow* MakePickScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id, stringw script)
{
	IGUIWindow* wnd_pickScript = env->addWindow(core::rect<s32>(250,100,750,500), false, L"Pickable Script", 0, 4501);

	//Layout GUI elements around
	editorManager->getGUIManager()->m_PickCheckBox_Equipable = editorManager->getGUIEnvironment()->addCheckBox(false, core::rect<int>(20,60,190,80), wnd_pickScript, 4502, L"Equipable");
	editorManager->getGUIManager()->m_PickCheckBox_Usable = editorManager->getGUIEnvironment()->addCheckBox(false, core::rect<int>(20,80,190,100), wnd_pickScript, 4504, L"Usable");
	editorManager->getGUIEnvironment()->addStaticText(L"EXISTING EVENTS:", core::rect<s32>(20,110,190,120), false, false, wnd_pickScript, 4505, false);
	editorManager->getGUIManager()->m_PickListBox_ExistingEvents = editorManager->getGUIEnvironment()->addListBox(core::rect<int>(20,120,100,220), wnd_pickScript, 4506, true);
	editorManager->getGUIEnvironment()->addStaticText(L"Event Script Action:", core::rect<s32>(200,110,420,120), false, false, wnd_pickScript, 4507, false);
	editorManager->getGUIManager()->m_PickEditBox_Script = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(110,120,480,220), true, wnd_pickScript, 4508);
	editorManager->getGUIManager()->m_PickEditBox_Script->setMultiLine(true);
	editorManager->getGUIManager()->m_PickEditBox_Script->setWordWrap(true);
	editorManager->getGUIEnvironment()->addStaticText(L"Add new event:", core::rect<s32>(20,235,90,250), false, false, wnd_pickScript, 4509, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Event target:", core::rect<s32>(20,275,90,295), false, false, wnd_pickScript, 4510, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Add new action:", core::rect<s32>(110,235,210,250), false, false, wnd_pickScript, 4511, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Action target:", core::rect<s32>(110,275,190,295), false, false, wnd_pickScript, 4512, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Action attribute:", core::rect<s32>(200,275,290,285), false, false, wnd_pickScript, 4513, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Action value:", core::rect<s32>(290,275,390,295), false, false, wnd_pickScript, 4514, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Target ID:", core::rect<s32>(110,315,190,335), false, false, wnd_pickScript, 4514, false);
	editorManager->getGUIManager()->m_PickComboBox_Events = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(20,250,100,270), wnd_pickScript, 4515);
	editorManager->getGUIManager()->m_PickComboBox_Actions = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(110,250,290,270), wnd_pickScript, 4516);
	editorManager->getGUIManager()->m_PickComboBox_EventTarget = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(20,290,100,310), wnd_pickScript, 4517);
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(110,290,190,310), wnd_pickScript, 4518);
	editorManager->getGUIManager()->m_PickEditBox_ActionAttribute = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(200,290,280,310), true, wnd_pickScript, 4519);
	editorManager->getGUIManager()->m_PickEditBox_ActionValue = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(290,290,370,310), true, wnd_pickScript, 4520);
	editorManager->getGUIManager()->m_PickEditBox_ActionTargetID = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(110,330,190,350), true, wnd_pickScript, 4521);
	editorManager->getGUIManager()->m_PickEditBox_ActionTargetID->setEnabled(false);
	editorManager->getGUIManager()->m_PickButton_AddEvent = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(20,320,100,340), wnd_pickScript, 4522, L"Add Event");
	editorManager->getGUIManager()->m_PickButton_RemoveEvent = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(20,350,100,370), wnd_pickScript, 4523, L"Remove Event");
	editorManager->getGUIManager()->m_PickButton_AddAction = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(290,320,370,340), wnd_pickScript, 4524, L"Add Action");
	editorManager->getGUIManager()->m_PickButton_Save = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(130,380,200,400), wnd_pickScript, 4525, L"Save");
	editorManager->getGUIManager()->m_PickButton_Cancel = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(230,380,300,400), wnd_pickScript, 4526, L"Cancel");
	editorManager->getGUIManager()->m_PickComboBox_Actions->addItem(L"none");
	editorManager->getGUIManager()->m_PickComboBox_Actions->setSelected(0);
	editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"none");
	editorManager->getGUIManager()->m_PickComboBox_Events->setSelected(0);
	editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnApproach");
	editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnPick");
	editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnDrop");
	editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnGive");
	editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnCombine");
	editorManager->getGUIManager()->m_PickComboBox_EventTarget->addItem(L"none");
	editorManager->getGUIManager()->m_PickComboBox_EventTarget->setSelected(0);
	editorManager->getGUIManager()->m_PickComboBox_EventTarget->addItem(L"player");
	editorManager->getGUIManager()->m_PickComboBox_EventTarget->addItem(L"self");
	editorManager->getGUIManager()->m_PickComboBox_EventTarget->addItem(L"id");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"none");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->setSelected(0);
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"player");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"self");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"id");

	//add actions
	for(u32 i=  0; i < editorManager->getScriptEngine()->m_ListOfScriptActions.size(); i++)
	{
		editorManager->getGUIManager()->m_PickComboBox_Actions->addItem(editorManager->getScriptEngine()->m_ListOfScriptActions[i].c_str());
	}

	//Save active script file name
	editorManager->getGUIManager()->m_PickScript = script.c_str();

	//change to script dir
	IFileSystem* fs = device->getFileSystem();
	fs->changeWorkingDirectoryTo("media/Scripts/Pickables");

	//Load existing script file if exists
	TScriptAction scriptAction;
	bool startLoadingScriptAction = false;
	bool loadingAction = false;
	stringc xml_filename = script.c_str();
	io::IXMLReader* xml = fs->createXMLReader(xml_filename.c_str());
	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case io::EXN_ELEMENT:
			{
				stringw figo;
				if (stringw("Usable") == xml->getNodeName())
				{
					figo = xml->getAttributeValue(L"value");
					editorManager->getGUIManager()->m_PickCheckBox_Usable->setChecked(figo == L"true");
				}
				else if (stringw("Equipable") == xml->getNodeName())
				{
					figo = xml->getAttributeValue(L"value");
					editorManager->getGUIManager()->m_PickCheckBox_Equipable->setChecked(figo == L"true");
				}
				else if (stringw("Script") == xml->getNodeName())
				{
					startLoadingScriptAction = true;
				}
				else if (startLoadingScriptAction)
				{
					if (!loadingAction)
					{
						scriptAction.event.name = xml->getNodeName();
						scriptAction.event.target = xml->getAttributeValue(L"target");
						scriptAction.actions.clear();
						loadingAction = true;
					}
					else
					{
						TAction action;
						action.name = xml->getNodeName();
						action.target = xml->getAttributeValue(L"target");
						action.attribute = xml->getAttributeValue(L"attribute");
						action.value = xml->getAttributeValue(L"value");
						scriptAction.actions.push_back(action);
					}
				}
			}
			break;
		case io::EXN_ELEMENT_END:
			{
				if (core::stringw("Script") == xml->getNodeName())
				{
					startLoadingScriptAction = false;
				}
				else if (scriptAction.event.name == xml->getNodeName())
				{
					//one event finished, add it to the list
					if(scriptAction.actions.size() > 0)
					{
						editorManager->getScriptEngine()->SelectedListOfScriptActions.push_back(scriptAction);
						editorManager->getGUIManager()->m_PickListBox_ExistingEvents->addItem(scriptAction.event.name.c_str());
					}
					loadingAction = false;
				}
			}
			break;
		}
	}
	if (xml)
		xml->drop(); // don't forget to delete the xml reader

	//add events
	if(editorManager->getGUIManager()->m_PickCheckBox_Usable->isChecked())
	{
		editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnUse");
		editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnUseAgainst");
	}
	if(editorManager->getGUIManager()->m_PickCheckBox_Equipable->isChecked())
	{
		editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnEquip");
		editorManager->getGUIManager()->m_PickComboBox_Events->addItem(L"OnUnequip");
	}

	if(editorManager->getGUIManager()->m_PickListBox_ExistingEvents->getItemCount()>0)
	{
		editorManager->getGUIManager()->m_PickListBox_ExistingEvents->setSelected(0);
		editorManager->getGUIManager()->WritePickScript(0);
	}
	
	editorManager->backToWorkingDirectory();
	return wnd_pickScript;
}

//creates window that allows user to add content to container
IGUIWindow* MakeNPCScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, stringc dialogFilename)
{
	IGUIWindow* wnd_NPC = env->addWindow(core::rect<s32>(210,50,850,650), false, L"NPC Script and Dialog", 0, 6500);

	//Layout GUI elements around

	//tab containing the tree element (tree element is not working correctly if not placed on tab!)
	IGUITabControl* tabPickables = env->addTabControl(core::rect<s32>(5,24,450,290), wnd_NPC, true, true);
	IGUITab* tab = tabPickables->addTab(L"Dialog Tree");

	//here are add/remove/link/enable dialog tree node buttons
	editorManager->getGUIManager()->m_DialogButton_AddNode = env->addButton(core::rect<s32>(460,55,560,75), wnd_NPC, 6510, L"Add Node");
	editorManager->getGUIManager()->m_DialogButton_RemoveNode = env->addButton(core::rect<s32>(460,85,560,105), wnd_NPC, 6511, L"Remove Node");
	editorManager->getGUIManager()->m_DialogButton_LinkNodes = env->addButton(core::rect<s32>(460,115,560,135), wnd_NPC, 6512, L"Link Nodes");
	editorManager->getGUIManager()->m_DialogButton_ToggleEnabled = env->addButton(core::rect<s32>(460,145,560,165), wnd_NPC, 6513, L"Toggle Enabled/Disabled");
	env->addStaticText(L"Selected Node ID:", core::rect<s32>(460,170,560,190), false, false, wnd_NPC, 6514, false);
	editorManager->getGUIManager()->m_DialogEditBox_SelectedNodeID = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(460,195,560,215), true, wnd_NPC, 6515);
	editorManager->getGUIManager()->m_DialogEditBox_SelectedNodeID->setEnabled(false);

	//dialog text edit window
	env->addStaticText(L"Dialog Text:", core::rect<s32>(5,295,130,305), false, false, wnd_NPC, 6520, false);
	editorManager->getGUIManager()->m_DialogEditBox_ChangeText = env->addEditBox(L"", core::rect<s32>(5,310,450,335), true, wnd_NPC, 6521);
	editorManager->getGUIManager()->m_DialogButton_ChangeText = env->addButton(core::rect<s32>(460,310,560,330), wnd_NPC, 6522, L"Change Text");
	editorManager->getGUIManager()->m_DialogEditBox_ChangeText->setMultiLine(true);
	editorManager->getGUIManager()->m_DialogEditBox_ChangeText->setWordWrap(true);
	editorManager->getGUIManager()->m_DialogEditBox_ChangeText->setAutoScroll(true);

	//dialog actions gui elements
	env->addStaticText(L"Add Action to selected dialog node:", core::rect<s32>(5,340,190,350), false, false, wnd_NPC, 6530, false);
	editorManager->getGUIManager()->m_DialogEditBox_ActionsText = env->addEditBox(L"", core::rect<s32>(5,355,450,470), true, wnd_NPC, 6531);
	editorManager->getGUIManager()->m_DialogEditBox_ActionsText->setMultiLine(true);
	editorManager->getGUIManager()->m_DialogEditBox_ActionsText->setWordWrap(true);
	editorManager->getGUIManager()->m_DialogComboBox_Actions = env->addComboBox(core::rect<s32>(460,355,590,375), wnd_NPC, 6532);
	env->addStaticText(L"select action target:", core::rect<s32>(460,380,580,390), false, false, wnd_NPC, 6533, false);
	editorManager->getGUIManager()->m_DialogComboBox_ActionTarget = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(460,390,520,410), wnd_NPC, 6534);
	editorManager->getGUIManager()->m_DialogEditBox_ActionTargetID = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(530,390,590,410), true, wnd_NPC, 6535);
	env->addStaticText(L"value:", core::rect<s32>(460,413,520,425), false, false, wnd_NPC, 6536, false);
	env->addStaticText(L"attribute:", core::rect<s32>(530,413,590,425), false, false, wnd_NPC, 6537, false);
	editorManager->getGUIManager()->m_DialogEditBox_ActionAttribute = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(530,422,590,442), true, wnd_NPC, 6538);
	editorManager->getGUIManager()->m_DialogEditBox_ActionValue = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(460,422,520,442), true, wnd_NPC, 6539);
	editorManager->getGUIManager()->m_DialogButton_AddAction = env->addButton(core::rect<s32>(530,450,590,470), wnd_NPC, 6540, L"Add Action");
	editorManager->getGUIManager()->m_DialogButton_ClearAction = env->addButton(core::rect<s32>(460,450,520,470), wnd_NPC, 6541, L"Clear Actions");
	editorManager->getGUIManager()->m_DialogEditBox_ActionTargetID->setEnabled(false);
	for(u32 i=  0; i < editorManager->getScriptEngine()->m_ListOfScriptActions.size(); i++)
	{
		editorManager->getGUIManager()->m_DialogComboBox_Actions->addItem(editorManager->getScriptEngine()->m_ListOfScriptActions[i].c_str());
	}
	editorManager->getGUIManager()->m_DialogComboBox_ActionTarget->addItem(L"none");
	editorManager->getGUIManager()->m_DialogComboBox_ActionTarget->setSelected(0);
	editorManager->getGUIManager()->m_DialogComboBox_ActionTarget->addItem(L"player");
	editorManager->getGUIManager()->m_DialogComboBox_ActionTarget->addItem(L"self");
	editorManager->getGUIManager()->m_DialogComboBox_ActionTarget->addItem(L"id");

	//dialog conditions
	env->addStaticText(L"Add Condition to selected dialog node:", core::rect<s32>(5,480,190,490), false, false, wnd_NPC, 6550, false);
	editorManager->getGUIManager()->m_DialogComboBox_Conditions = env->addComboBox(core::rect<s32>(5,495,450,515), wnd_NPC, 6551);
	editorManager->getGUIManager()->m_DialogButton_AddCondition = env->addButton(core::rect<s32>(460,495,560,515), wnd_NPC, 6552, L"Add Condition");

	//ok and cancel buttons
	editorManager->getGUIManager()->m_DialogButton_Ok = env->addButton(core::rect<s32>(460,555,530,575), wnd_NPC, 6560, L"Ok");
	editorManager->getGUIManager()->m_DialogButton_Cancel = env->addButton(core::rect<s32>(540,555,610,575), wnd_NPC, 6561, L"Cancel");
	env->setFocus(editorManager->getGUIManager()->m_DialogButton_AddNode);

	//File system
	IFileSystem* fs = device->getFileSystem();
	fs->changeWorkingDirectoryTo("media/Dialogs");

	//Load Dialog Tree
	PopulateDialogTreeNodeFromXML(editorManager, env, device, dialogFilename.c_str(), tab, rect<s32>(5,10,430,225));

	//Back to root dir
	editorManager->backToWorkingDirectory();

	return wnd_NPC;
}


//creates window that allows user to add content to container
IGUIWindow* MakeMonsterScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id, stringc filename)
{
	IGUIWindow* wnd_containerContent = env->addWindow(core::rect<s32>(250,100,750,500), false, L"Container Content", 0, 4500);

	//Layout GUI elements around
	//env->addStaticText(L"Add new action:", core::rect<s32>(110,235,210,250), false, false, wnd_triggerScript, 4510, false);

	//File system
	IFileSystem* fs = device->getFileSystem();
	fs->changeWorkingDirectoryTo("media/GameObjects/Pickables");


	return wnd_containerContent;
}

//creates window that allows user to add content to container
IGUIWindow* MakeTriggerScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id, stringw script)
{
	IGUIWindow* wnd_triggerScript = env->addWindow(core::rect<s32>(250,100,750,500), false, L"Trigger Script", 0, 4500);

	//Layout GUI elements around
	editorManager->getGUIEnvironment()->addStaticText(L"Chose State:", core::rect<s32>(20,110,190,120), false, false, wnd_triggerScript, 4505, false);
	editorManager->getGUIManager()->m_TriggerListBox_States = editorManager->getGUIEnvironment()->addListBox(core::rect<int>(20,120,100,220), wnd_triggerScript, 4506, true);
	editorManager->getGUIEnvironment()->addStaticText(L"Trigger Script Action:", core::rect<s32>(200,110,420,120), false, false, wnd_triggerScript, 4507, false);
	editorManager->getGUIManager()->m_PickEditBox_Script = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(110,120,480,220), true, wnd_triggerScript, 4508);
	editorManager->getGUIManager()->m_PickEditBox_Script->setMultiLine(true);
	editorManager->getGUIManager()->m_PickEditBox_Script->setWordWrap(true);
	editorManager->getGUIEnvironment()->addStaticText(L"Add new tate:", core::rect<s32>(20,235,90,250), false, false, wnd_triggerScript, 4509, false);
	//editorManager->getGUIEnvironment()->addStaticText(L"Event target:", core::rect<s32>(20,275,90,295), false, false, wnd_triggerScript, 4510, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Add new action:", core::rect<s32>(110,235,210,250), false, false, wnd_triggerScript, 4510, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Action target:", core::rect<s32>(110,275,190,295), false, false, wnd_triggerScript, 4511, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Action attribute:", core::rect<s32>(200,275,290,285), false, false, wnd_triggerScript, 4512, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Action value:", core::rect<s32>(290,275,390,295), false, false, wnd_triggerScript, 4513, false);
	editorManager->getGUIEnvironment()->addStaticText(L"Target ID:", core::rect<s32>(110,315,190,335), false, false, wnd_triggerScript, 4514, false);
	editorManager->getGUIManager()->m_TriggerEditBox_State = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(20,250,100,270), true, wnd_triggerScript, 4515);
	//editorManager->getGUIManager()->m_PickComboBox_Events = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(20,250,100,270), wnd_triggerScript, 4515);
	editorManager->getGUIManager()->m_PickComboBox_Actions = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(110,250,290,270), wnd_triggerScript, 4516);
	//editorManager->getGUIManager()->m_PickComboBox_EventTarget = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(20,290,100,310), wnd_triggerScript, 4517);
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget = editorManager->getGUIEnvironment()->addComboBox(core::rect<s32>(110,290,190,310), wnd_triggerScript, 4518);
	editorManager->getGUIManager()->m_PickEditBox_ActionAttribute = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(200,290,280,310), true, wnd_triggerScript, 4519);
	editorManager->getGUIManager()->m_PickEditBox_ActionValue = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(290,290,370,310), true, wnd_triggerScript, 4520);
	editorManager->getGUIManager()->m_PickEditBox_ActionTargetID = editorManager->getGUIEnvironment()->addEditBox(L"", core::rect<s32>(110,330,190,350), true, wnd_triggerScript, 4521);
	editorManager->getGUIManager()->m_PickEditBox_ActionTargetID->setEnabled(false);
	editorManager->getGUIManager()->m_TriggerButton_SetState = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(20,280,100,300), wnd_triggerScript, 4522, L"Set Default State");
	editorManager->getGUIManager()->m_TriggerButton_AddState = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(20,310,100,330), wnd_triggerScript, 4523, L"Add State");
	editorManager->getGUIManager()->m_TriggerButton_RemoveState = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(20,340,100,360), wnd_triggerScript, 4524, L"Remove State");
	editorManager->getGUIManager()->m_PickButton_AddAction = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(290,320,370,340), wnd_triggerScript, 4525, L"Add Action");
	editorManager->getGUIManager()->m_PickButton_Save = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(130,380,200,400), wnd_triggerScript, 4526, L"Save");
	editorManager->getGUIManager()->m_PickButton_Cancel = editorManager->getGUIEnvironment()->addButton(core::rect<s32>(230,380,300,400), wnd_triggerScript, 4527, L"Cancel");
	editorManager->getGUIManager()->m_PickComboBox_Actions->addItem(L"none");
	editorManager->getGUIManager()->m_PickComboBox_Actions->setSelected(0);
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"none");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->setSelected(0);
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"player");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"self");
	editorManager->getGUIManager()->m_PickComboBox_ActionTarget->addItem(L"id");

	for(u32 i=  0; i < editorManager->getScriptEngine()->m_ListOfScriptActions.size(); i++)
	{
		editorManager->getGUIManager()->m_PickComboBox_Actions->addItem(editorManager->getScriptEngine()->m_ListOfScriptActions[i].c_str());
	}

	IFileSystem* fs = device->getFileSystem();
	fs->changeWorkingDirectoryTo("media/Scripts/Static");

	//Load existing script file if exists
	TScriptAction scriptAction;
	bool startLoadingScriptAction = false;
	bool loadingAction = false;
	stringw default_state;
	stringc xml_filename = script.c_str();
	io::IXMLReader* xml = fs->createXMLReader(xml_filename.c_str());
	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case io::EXN_ELEMENT:
			{
				if (stringw("State") == xml->getNodeName())
				{
					editorManager->getEdiLevel()->m_ListOfGameObjects[id]->state = xml->getAttributeValue(L"value");
					default_state = xml->getAttributeValue(L"value");
				}
				else if (stringw("Script") == xml->getNodeName())
				{
					startLoadingScriptAction = true;
				}
				else if (startLoadingScriptAction)
				{
					if (!loadingAction)
					{
						scriptAction.event.name = xml->getNodeName();
						editorManager->getGUIManager()->m_TriggerListBox_States->addItem(xml->getAttributeValue(L"state"));
						if(stringw(xml->getAttributeValue(L"state")) == default_state)
						{
							editorManager->getGUIManager()->m_TriggerListBox_States->setSelected(editorManager->getGUIManager()->m_TriggerListBox_States->getItemCount()-1);
						}
						scriptAction.event.state = xml->getAttributeValue(L"state");
						scriptAction.actions.clear();
						loadingAction = true;
					}
					else
					{
						TAction action;
						action.name = xml->getNodeName();
						action.target = xml->getAttributeValue(L"target");
						action.attribute = xml->getAttributeValue(L"attribute");
						action.value = xml->getAttributeValue(L"value");
						scriptAction.actions.push_back(action);
					}
				}
			}
			break;
		case io::EXN_ELEMENT_END:
			{
				if (core::stringw("Script") == xml->getNodeName())
				{
					startLoadingScriptAction = false;
				}
				else if (scriptAction.event.name == xml->getNodeName())
				{
					//one event finished, add it to the list
					if(scriptAction.actions.size() > 0)
					{
						editorManager->getScriptEngine()->SelectedListOfScriptActions.push_back(scriptAction);
					}
					loadingAction = false;
				}
			}
			break;
		}
	}
	if (xml)
		xml->drop(); // don't forget to delete the xml reader

	if(editorManager->getScriptEngine()->SelectedListOfScriptActions.size() > 0)
	{
		if(editorManager->getGUIManager()->m_TriggerListBox_States->getSelected() > -1)
		{
			editorManager->getGUIManager()->WriteTriggerScript(editorManager->getGUIManager()->m_TriggerListBox_States->getSelected());
		}
		else
		{
			editorManager->getGUIManager()->m_TriggerListBox_States->setSelected(0);
			editorManager->getGUIManager()->WriteTriggerScript(0);
		}
	}

	editorManager->backToWorkingDirectory();
	return wnd_triggerScript;
}