
// this lovely file contains declarations of function for creating GUI windows.
//
// there are several GUI windows in level editor and all are created here
// Game Object window
// Properties window
// Container Content window (pops up when you want to add content to container)



#include <irrlicht.h>

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CEditorManager;

void PopulateTreeNodeFromXML(IGUIEnvironment* env, IrrlichtDevice* device, stringc dir_filename, IGUIElement *parent, core::rect<s32> position, s32 id);
IGUIWindow* MakeContainerContentWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id);
IGUIWindow* MakeGameObjectsWindow(IGUIEnvironment* env, IrrlichtDevice* device);
IGUIWindow* MakePropertiesWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device);
IGUIWindow* MakePickScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id, stringw script);
IGUIWindow* MakeTriggerScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, s32 id, stringw filename);
IGUIWindow* MakeNPCScriptWindow(CEditorManager* editorManager, IGUIEnvironment* env, IrrlichtDevice* device, stringc filename);

