/** 
 * \file EDLevel.h
 * \brief Header file containing CEditorLevel class used for managing 3D action.
 * CEditorLevel class handles 3D models, saving and loading map, rotating/scaling/trans objects etc...
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_EDLEVELICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_EDLEVELICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_


#include <irrlicht.h>
#include "../gui/EDGui.h"
#include "RTSCamera.h"
#include "GameObject.h"
//#include "../EditorManager.h"
using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CEditorManager;

/**
 * \brief CEditorLevel class manages 3D game objects.
 *
 * It takes care of saving/loading levels 
 * manages game object arrays (adding deleting game objects)
 * allows translation, rotation and scaling of models.
 * implements undo/redo functionality
 * translates events to game objects -> on mouse click, on rotate etc..
 * tightly communicates with GUI environment, for example: 
 *  - selecting different game object causes changes in GUI window Properties
 *  - changed game object properties must be saved to map file
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CEditorLevel : public ISceneUserDataSerializer 
{
public:
	CEditorLevel();
	~CEditorLevel();
	bool Init(CEditorManager* edMngr);
	bool OnEvent(const SEvent& event);
	void OnLoadMap(stringc filename);
	void CreateCamera(vector3df position);
	void addTerrainSelector();
	bool SetElementAtHand(stringc filename, TGameObjectProperty properties);
	bool SendModelToPhotoSession(stringc filename, TGameObjectProperty properties);
	bool SendModelToPickSession(stringc filename, TGameObjectProperty properties);
	void RemovePhotoSessionModel();
	void RemovePickSessionModel();
	void SetMapName(stringc mapname);
	void SetLoadingDir(stringc mapname);
	bool SingleObjectSelected();
	void OnRender();
	/* ISceneUserDataSerializer functions: */
	IAttributes* createUserData (irr::scene::ISceneNode *forSceneNode);
	void OnReadUserData (irr::scene::ISceneNode *forSceneNode, irr::io::IAttributes *userData);

	CEditorManager* m_EditorManager;
	//we need list of game objects here
	ISceneNode* m_SelectedGameObject;
	ISceneNode* m_PreviewGameObject;
	ISceneNode* m_PreviewPickGameObject;
	bool m_bMoveSelectedNode;
	bool m_bElementAtHand;
	bool m_bShiftPressed;
	bool m_bRotateSelectedNode;
	stringc m_MapName;
	stringc m_LoadingDir;
	s32 m_NodeRotationX;
	core::array <CGameObject*> m_ListOfGameObjects;
	vector3df m_CurrentZoom;
	vector3df m_CurrentRotationOfSelectedNode;
	vector3df m_instersection_point;
	vector3df m_selectedGameObjectStartMovingPosition;
	RTSCamera* m_LevelCamera;
};

#endif