/** 
 * \file GameObject.h
 * \brief Header file containing CGameObject class used for storing Game object attributes and data.
 * CGameObject class handles mesh name and id, list of pickable items (if the object is container), etc...
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
#include "../Script.h"

using namespace irr;
using namespace core;

class CGameObject
{
public:

	CGameObject();
	~CGameObject();
	void AddPickableItem(stringc item);
	stringc GetPickableItem(s32 id);
	void ClearPickableItems();
	s32 GetNumberOfPickableItems();
	void ClearScriptActions();

	stringw name;
	stringw mesh;
	stringw position;
	bool isVisible;
	bool isPickable;
	bool isTrigger;
	bool isNPC;
	bool isMonster;
	bool isContainer;
	stringw description;
	stringw script;
	stringw state;
	//only container objects have this list to asociate them to pickable items they contain
	array <stringc> m_ListOfPickableItems;
	array <TScriptAction> m_ListOfScriptActions;
	u32 id;
};