/** 
 * \file PlayerCharacter.h
 * \brief Header file containing CPlayerCharacter class.
 * CPlayerCharacter class manages player state and action.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
#include "CCharacter.h"

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CPlayerCharacter : public CCharacter
{
public:

	CPlayerCharacter();
	~CPlayerCharacter();
	bool Load(IrrlichtDevice* device, irr::scene::ISceneManager *smgr,
			  irr::video::IVideoDriver *videodriver, const c8* xmlPath);
	bool ReadXMLAttributes(IFileSystem* fs, stringc xml_filename);

	stringw name;
	stringw mesh_filename;
	stringw position;
	bool isVisible;
	u32 id;

	
	//Inventory
};