/** 
 * \file Level.cpp
 * \brief File Level.cpp takes care of level structure - it hold together all game objects on the level.
 *
 * takes care of saving/loading level
 * manages game object arrays (adding deleting game objects)
 * translates events to game objects -> on mouse click, on rotate etc..
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include "Level.h"
	

CLevel::CLevel()
{
	m_ID = 0;
}

CLevel::~CLevel()
{
}

bool CLevel::Init(IFileSystem* fs, IVideoDriver* driver, ISceneManager* smgr)
{
	m_ID = 0;
	m_pFS = fs;
	m_pDriver = driver;
	m_SMGR = smgr;
	return true;
}

bool CLevel::Load(const c8* map_filename)
{
	m_ID = 0; //cleaning old map
	m_SMGR->clear();

	if (m_SMGR->loadScene(map_filename,this))
	{
		m_SMGR->getActiveCamera()->remove(); //TODO: Make RTS camera load properly from irr file
		addTerrainSelector();
		return true;
	}

	return false;
}

/**
 * \brief Adds triangle selector to the terrain (used on reloading map)
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
void CLevel::addTerrainSelector()
{
	ITerrainSceneNode* terrain = (ITerrainSceneNode*) m_SMGR->getSceneNodeFromType(ESNT_TERRAIN);
	scene::ITriangleSelector* selector = m_SMGR->createTerrainTriangleSelector(terrain, 0);
	terrain->setTriangleSelector(selector);
	selector->drop();
}

IAttributes* CLevel::createUserData (irr::scene::ISceneNode *sceneNode)
{
	IAttributes* attr = m_pFS->createEmptyAttributes(m_pDriver);

	/*attr->addString("Homepage",L"www.mystic-peanut.com");

	if(sceneNode->getType() != ESNT_TERRAIN)
	{
		if((sceneNode->getID() >= 0) && (sceneNode->getID() < (s32)m_ListOfGameObjects.size()))
		{
			if (m_ListOfGameObjects[sceneNode->getID()]->isContainer)
				attr->addBool("isContainer",true);
		}
	}*/
	return attr;
}

void CLevel::OnReadUserData (irr::scene::ISceneNode *sceneNode, irr::io::IAttributes *userData)
{
	//ignoring camera, terrain and other special nodes with ID = -1
	if(sceneNode->getID() >= 0)
	{
		//adding new game object to the map
/*		
		CGameObject* gameObject = new CGameObject();
		if(userData->getAttributeAsBool("isContainer"))
		{
			gameObject->isContainer = true;
		}
		gameObject->id = m_EditorManager->m_ID;
		m_ListOfGameObjects.push_back(gameObject);
		if (m_EditorManager->m_ID != sceneNode->getID())
		{
			sceneNode->setID(m_EditorManager->m_ID); //This should never happen
			stringw message = "Node IDs are messed up. Map might not work properly.";
			m_EditorManager->getGUIEnvironment()->addMessageBox(L"Error loading map!", message.c_str());
		}
*/
		m_ID++;
	}
}
