/** 
 * \file Level.h
 * \brief Header file containing CLevel class that is game level.
 * CLevel class manages game objects on the map.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CLevel : public ISceneUserDataSerializer 
{
public:

	CLevel();
	~CLevel();
	bool Init(IFileSystem* fs, IVideoDriver* driver, ISceneManager* smgr);
	bool Load(const c8* map_filename);
	void addTerrainSelector();

	/* ISceneUserDataSerializer functions: */
	IAttributes* createUserData (irr::scene::ISceneNode *forSceneNode);
	void OnReadUserData (irr::scene::ISceneNode *forSceneNode, irr::io::IAttributes *userData);
	
	IFileSystem* m_pFS;
	IVideoDriver* m_pDriver;
	ISceneManager* m_SMGR;
	s32 m_ID;
	//array of game objects on this level
};