
/*
 * File CCharacter.h is taken from irrlicht forum. Class is created by FOSP Team.
 * link: http://irrlicht.sourceforge.net/phpBB2/viewtopic.php?t=27882
 * I changed that code little bit to suite my needs.
 * Big thanks to FOSP Team.
 *
 *
 ***********************************************
 * Character control
 * *********************************************
 * file name: CCharacter.h
 * encoding: UTF-8
 * tab size: 8
 * indentation: 4
 * created on: 8:55 PM 3/17/2008
 * init by: Do Quoc Khanh - doqkhanh
 * created by: FOSP Team
 * copyright: FOS Project http://fosp.wordpress.com/ 
 */

#pragma once
#include <irrlicht.h>

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CCharacter : public irr::scene::IAnimationEndCallBack
{
private:
   float fSpeed;
   scene::IAnimatedMeshSceneNode* node;


public:

	//Anim
	s32 Anim_Walk_start;
	s32 Anim_Walk_end;
	s32 Anim_Idle_start;
	s32 Anim_Idle_end;

	enum eAttacktype{
      MagicAttack,
      PowerAttack,
      DownswipeAttack
   };

   enum eState{
      Run,
      Walk,
      Attack,
      Idle
   };   
   
   eAttacktype curAttackType;
   eState curState;
   eState oldState;
   core::vector3df targetPosition;

public:
   CCharacter();
   ~CCharacter(void);
	bool Init(IrrlichtDevice* device, irr::scene::ISceneManager *smgr,irr::video::IVideoDriver *videodriver, const c8* meshPath);
	void setState(eState newState);
   void setPosition(core::vector3df pos);
   void setTargetPosition(core::vector3df pos);
   void setRotate(core::vector3df rot);
   
   core::vector3df getPosition();
   core::vector3df getRotate();
   eState getState();
   irr::scene::IAnimatedMeshSceneNode* getMesh();
   irr::scene::IAnimatedMeshSceneNode* getNode();

   void run();
   void walk();
   void attack(eAttacktype);
   void idle();

   void move(core::vector3df pos, f32 elapsed_time);
   void update(f32 elapsed_time);

   void remove();

   void OnAnimationEnd(IAnimatedMeshSceneNode* node);
};
