/** 
 * \file CPickableItem.h
 * \brief Header file containing CPickableItem class used for game objects that can be placed in inventory.
 * Pickable objects are caracterized by having both 3d and 2d representation (icon).
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>

using namespace irr;
using namespace gui;
using namespace core;
using namespace video;

/**
 * \brief CPickableItem class represents game objects that can be placed in inventory.
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CPickableItem
{
public:
	//Constructor
	CPickableItem();
	//! destructor
	~CPickableItem();
	inline stringc getName() {return m_Name;}
	inline void setName(stringc name) {m_Name = name;}

	ITexture* m_IconTexture;
private:
	stringc m_Name;
};
