/** 
 * \file GameObject.cpp
 * \brief GameObject class is used for storing Game object attributes and data.
 * CGameObject class handles mesh name, id, and parameters like isContainer, isNPC, etc...
 * it also handles list of pickable items (if the object is container) of the object.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include "GameObject.h"

CGameObject::CGameObject()
{
	isContainer = false;
}

CGameObject::~CGameObject()
{
}

void CGameObject::AddPickableItem(stringc item)
{
	m_ListOfPickableItems.push_back(item);
}

stringc CGameObject::GetPickableItem(s32 id)
{
	return m_ListOfPickableItems[id];
}

void CGameObject::ClearPickableItems()
{
	m_ListOfPickableItems.clear();
}

s32 CGameObject::GetNumberOfPickableItems()
{
	return m_ListOfPickableItems.size();
}