/** 
 * \file GameObject.h
 * \brief Header file containing CGameObject class used for storing Game object attributes and data.
 * CGameObject class handles mesh name and id, list of pickable items (if the object is container), etc...
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
using namespace irr;
using namespace core;

class CGameObject
{
public:

	CGameObject();
	~CGameObject();
	void AddPickableItem(stringc item);
	stringc GetPickableItem(s32 id);
	void ClearPickableItems();
	s32 GetNumberOfPickableItems();

	stringw name;
	stringw mesh;
	stringw position;
	bool isContainer;
	bool isVisible;
	core::array <stringc> m_ListOfPickableItems;
	u32 id;
};