
/*
 * File CCharacter.cpp is taken from irrlicht forum. Class is created by FOSP Team.
 * link: http://irrlicht.sourceforge.net/phpBB2/viewtopic.php?t=27882
 * I changed that code little bit to suite my needs.
 * Big thanks to FOSP Team.
 *
 * ***********************************************
 * Character control
 * *********************************************
 * file name: CCharacter.cpp
 * encoding: UTF-8
 * tab size: 8
 * indentation: 4
 * created on: 9:03 PM 3/17/2008
 * init by: Do Quoc Khanh - doqkhanh
 * created by: FOSP Team
 * copyright: FOS Project http://fosp.wordpress.com/ 
 */
#include "CCharacter.h"

#include <irrlicht.h>
#define ANIMATION_SPEED 25
irr::scene::IAnimatedMeshSceneNode* CCharacter::getMesh()
{
   return node;
}

CCharacter::CCharacter()
{
}

CCharacter::~CCharacter(void)
{
	//node is removed by smgr->clear()
   //node->remove();
}

bool CCharacter::Init(IrrlichtDevice* device, irr::scene::ISceneManager *smgr,irr::video::IVideoDriver *videodriver, const c8* meshPath)
{
   node = smgr->addAnimatedMeshSceneNode(smgr->getMesh(meshPath));
   
   if (node)
   {
		node->setMaterialFlag(video::EMF_LIGHTING, false);

		fSpeed = 84.f;

		curState = CCharacter::eState::Idle;
		oldState = CCharacter::eState::Idle;

		curAttackType = CCharacter::eAttacktype::MagicAttack;

		node->setJointMode(irr::scene::EJUOR_CONTROL);
		node->setTransitionTime(0.5);
			
		idle();

		return true;
   }

   return false;
}

void CCharacter::setState(eState newState)
{
   oldState = curState;
   curState = newState;
}

void CCharacter::setPosition(core::vector3df pos)
{
   node->setPosition(pos);
}

void CCharacter::setTargetPosition(core::vector3df pos)
{
   targetPosition = pos;
   walk();
}

void CCharacter::setRotate(core::vector3df rot)
{
   node->setRotation(rot);
}

   
core::vector3df CCharacter::getPosition()
{
   return node->getPosition();
}

core::vector3df CCharacter::getRotate()
{
   return node->getRotation();
}

CCharacter::eState CCharacter::getState()
{
   return curState;
}


void CCharacter::run()
{
   setState(CCharacter::eState::Run);
   
   node->setAnimationSpeed(ANIMATION_SPEED);
   node->setLoopMode(true);
   node->setFrameLoop(1,14);
}

void CCharacter::walk()
{
   setState(CCharacter::eState::Walk);
   
   node->setAnimationSpeed(ANIMATION_SPEED);
   node->setLoopMode(true);
   node->setFrameLoop(Anim_Walk_start,Anim_Walk_end);
}

void CCharacter::idle()
{
   setState(CCharacter::eState::Idle);
   
   node->setAnimationSpeed(ANIMATION_SPEED);
   node->setLoopMode(true);
   node->setFrameLoop(Anim_Idle_start,Anim_Idle_end);
}


void CCharacter::attack(eAttacktype attackType)
{
   setState(CCharacter::eState::Attack);
   switch (attackType)
   {
      case eAttacktype::PowerAttack :
      {   
         node->setAnimationSpeed(ANIMATION_SPEED);
         node->setLoopMode(false);
         node->setFrameLoop(45,59);
         node->setAnimationEndCallback(this);
         return;
      }    

      case eAttacktype::DownswipeAttack:
      {   
         node->setAnimationSpeed(ANIMATION_SPEED);
         node->setLoopMode(false);
         node->setFrameLoop(60,68);
         node->setAnimationEndCallback(this);
         return;
      }

      case eAttacktype::MagicAttack:
      {   
         node->setAnimationSpeed(ANIMATION_SPEED);
         node->setLoopMode(false);
         node->setFrameLoop(69,72);
         node->setAnimationEndCallback(this);
         return;
      }

   }

}


core::vector3df faceTarget(irr::core::vector3df targetpos, irr::core::vector3df nodepos) {

  core::vector3df posDiff = targetpos - nodepos;
  f32 degree = nodepos.Y; //keep current rotation if nothing to do
  posDiff.normalize();

  if (posDiff.X != 0.0f || posDiff.Z != 0.0f)
    degree = atan2(posDiff.X,posDiff.Z) * core::RADTODEG;

  return core::vector3df(0,degree,0);
}


void moveto(irr::scene::ISceneNode *node, //node to move
            irr::core::vector3df vel) //velocity vector
{
    irr::core::matrix4 m;
    m.setRotationDegrees(node->getRotation());
    m.transformVect(vel);
    node->setPosition(node->getPosition() + vel);
    node->updateAbsolutePosition();
}

void CCharacter::move(core::vector3df pos, f32 elapsed_time)
{
	// Avoid complex operation in next step
	if(getState() != CCharacter::eState::Walk && getState() != CCharacter::eState::Run)
		return;

	//Rotate even if its close enough
	node->setRotation(  faceTarget(pos, node->getPosition()) );

	if (node->getPosition().getDistanceFrom(pos) < 4)
	{
		idle();
	}
	else
	{
		moveto(node, core::vector3df(0,0,fSpeed*elapsed_time));
	}

}

void CCharacter::update(f32 elapsed_time)
{
	if(getState() != CCharacter::eState::Idle)
		move(targetPosition, elapsed_time);
	node->animateJoints() ;
}

void CCharacter::OnAnimationEnd(IAnimatedMeshSceneNode* node)
{
    idle();
}

void CCharacter::remove()
{
   node->remove();
}

irr::scene::IAnimatedMeshSceneNode* CCharacter::getNode()
{
   return node;   
} 