/** 
 * \file PlayerCharacter.cpp
 * \brief File PlayerCharacter.cpp class manages player state and action.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include "PlayerCharacter.h"
	

CPlayerCharacter::CPlayerCharacter()
: CCharacter()
{
}

CPlayerCharacter::~CPlayerCharacter()
{
}

bool CPlayerCharacter::Load(IrrlichtDevice* device, irr::scene::ISceneManager *smgr,irr::video::IVideoDriver *videodriver, const c8* xmlPath)
{
	if (ReadXMLAttributes(device->getFileSystem(),xmlPath))
	{
		stringc temp = mesh_filename.c_str();
		if(Init(device,smgr,videodriver,temp.c_str()))
			return true;
	}

	return false;
}

bool CPlayerCharacter::ReadXMLAttributes(IFileSystem* fs, stringc xml_filename)
{
	bool success = false;
	bool startStoringAbilities = false;
	bool startStoringSkills = false;

	IXMLReader* xml = fs->createXMLReader(xml_filename.c_str());

	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case io::EXN_ELEMENT:
			{
				stringw figo = xml->getNodeName();
				if(core::stringw("Model") == xml->getNodeName())
				{
					mesh_filename = xml->getAttributeValue(L"filename");
				}
				else if (core::stringw("Character") == xml->getNodeName())
				{
					success = true; //This means it found Player.xml file and it had Character tag
				}
				else if (core::stringw("Walk") == xml->getNodeName())
				{
					Anim_Walk_start = xml->getAttributeValueAsInt(L"animation_start");
					Anim_Walk_end = xml->getAttributeValueAsInt(L"animation_end");
				}
				else if (core::stringw("Idle") == xml->getNodeName())
				{
					Anim_Idle_start = xml->getAttributeValueAsInt(L"animation_start");
					Anim_Idle_end = xml->getAttributeValueAsInt(L"animation_end");
				}
				else if (core::stringw("Ability") == xml->getNodeName())
				{
					startStoringAbilities = true;
				}
				else if (core::stringw("Skills") == xml->getNodeName())
				{
					//abilities loaded.
					startStoringSkills = true;
				}
				else if (startStoringAbilities)
				{
					TAbility ability;
					ability.name = xml->getNodeName();
					ability.value = xml->getAttributeValueAsInt(L"value");
					ability.min = xml->getAttributeValueAsInt(L"min");
					ability.max = xml->getAttributeValueAsInt(L"max");
					m_ListOfAbilities.push_back(ability);
				}
				else if (startStoringSkills)
				{
					TSkill skill;
					skill.name = xml->getNodeName();
					skill.value = xml->getAttributeValueAsInt(L"value");
					skill.min = xml->getAttributeValueAsInt(L"min");
					skill.max = xml->getAttributeValueAsInt(L"max");
					m_ListOfSkills.push_back(skill);
				}
			}
			break;
		case io::EXN_ELEMENT_END:
			{
				if (core::stringw("Ability") == xml->getNodeName())
				{
					//abilities loaded.
					startStoringAbilities = false;
				}
				else if (core::stringw("Skills") == xml->getNodeName())
				{
					//abilities loaded.
					startStoringSkills = false;
				}
			}
			break;

		}
	}

	if (xml)
		xml->drop(); // don't forget to delete the xml reader

	return success;
}