/** 
 * \file PlayerCharacter.h
 * \brief Header file containing CPlayerCharacter class.
 * CPlayerCharacter class manages player state and action.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
#include "CCharacter.h"

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

typedef struct S_Ability
{
	stringw name;
	s32 value;
	s32 min;
	s32 max;
} TAbility;

typedef struct S_Skill
{
	stringw name;
	s32 value;
	s32 min;
	s32 max;
} TSkill;

class CPlayerCharacter : public CCharacter
{
public:

	CPlayerCharacter();
	~CPlayerCharacter();
	bool Load(IrrlichtDevice* device, irr::scene::ISceneManager *smgr,
			  irr::video::IVideoDriver *videodriver, const c8* xmlPath);
	bool ReadXMLAttributes(IFileSystem* fs, stringc xml_filename);

	stringw name;
	stringw mesh_filename;
	stringw position;

	array<TAbility> m_ListOfAbilities;
	array<TSkill> m_ListOfSkills;

	bool isVisible;
	u32 id;

	
	//Inventory!!
};