/** 
 * \file LevelManager.h
 * \brief Header file containing CLevelManager class used for managing game levels.
 * CLevelManager class handles saving and loading maps, and handles map related user events.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_EDLEVELICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_EDLEVELICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_


#include <irrlicht.h>
//#include "../gui/GameGUI.h"
#include "RTSCamera.h"
#include "Level.h"
#include "../GameManager.h"
using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CGameManager;
class CGameGUI;

/**
 * \brief CLevelManager class manages 3D game objects.
 *
 * It takes care of saving/loading levels 
 * manages game object arrays (adding deleting game objects)
 * allows translation, rotation and scaling of models.
 * implements undo/redo functionality
 * translates events to game objects -> on mouse click, on rotate etc..
 * tightly communicates with GUI environment, for example: 
 *  - selecting different game object causes changes in GUI window Properties
 *  - changed game object properties must be saved to map file
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CLevelManager// : public ISceneUserDataSerializer 
{
public:
	CLevelManager();
	~CLevelManager();
	bool Init(CGameManager* gameMngr, CGameGUI* gameGUI);
	bool OnEvent(const SEvent& event);
	bool OnLoadMap(const c8* map_filename);
	void CreateCamera(vector3df position);
	//bool SetElementAtHand(stringc filename, TGameObjectProperty properties);
	//bool SingleObjectSelected();
	void OnRender();
	/* ISceneUserDataSerializer functions: */
	//IAttributes* createUserData (irr::scene::ISceneNode *forSceneNode);
	//void OnReadUserData (irr::scene::ISceneNode *forSceneNode, irr::io::IAttributes *userData);

	CGameManager* m_GameManager;
	CGameGUI* m_GameGUI;
	CLevel* m_pLevels[10];
	s32 m_LevelIndex;
	//we need list of game objects here
	//ISceneNode* m_SelectedGameObject;
	//bool m_bMoveSelectedNode;
	bool m_bShiftPressed;
	bool m_bHoverOverActionItem;
	//bool m_bRotateSelectedNode;
	//s32 m_NodeRotationX;
	//core::array <CGameObject*> m_ListOfGameObjects;
	vector3df m_CurrentZoom;
	//vector3df m_CurrentRotationOfSelectedNode;
	vector3df m_instersection_point;
	//vector3df m_selectedGameObjectStartMovingPosition;
};

#endif