/** 
 * \file GameManager.h
 * \brief CGameManager class is the boss. The manager. It creates 3D device (irrlicht of course),
 * creates GUI, and 3D environment so called Level Game. Calls all the initialization functions and 
 * goes to the loop.
 * 
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_GAMEMANAGER_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_GAMEMANAGER_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_


#include <irrlicht.h>
#include "level/LevelManager.h"
#include "PlayerCharacter.h"
#include "gui/GameGUI.h"
#include "Script.h"
#include "level/CGoToArrows.h"

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CLevelManager;

/**
 * \brief CGameManager class is the boss. The manager. It creates 3D device (irrlicht of course),
 * creates GUI, and 3D environment so called Level Game. Calls all the initialization functions and 
 * goes to the loop.
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CGameManager : public IEventReceiver
{
public:
	CGameManager();
	~CGameManager();
	void Update(f32 elapsed_time);
	bool Init();
	bool LoadDataFromXMLConfig(stringc filename);
	IrrlichtDevice* getDevice();
	IVideoDriver* getDriver();
	ISceneManager* getSceneMngr();
	IGUIEnvironment* getGUIEnvironment();
	void DisplayError();
	CGameGUI* getGameGUI() {return m_GameGUI;}
	CLevelManager* getLevelManager() {return m_pLevelManager;}
	CPlayerCharacter* getPC() {return m_pPC;}
	IFileSystem* getFS() {return m_FS;}
	void backToWorkingDirectory();
	stringw getRootNameFromPathName(stringw meshName);
	virtual bool OnEvent(const SEvent& event);
	bool LoadPC();
	void resetArrows();

	s32 m_ID;
	bool m_bInitOk;
	stringc m_StartMap;
	stringc m_PlayerConfigFile;
	stringc m_WorkingDir;
	stringw m_WndCaption;
	CScript* m_pScriptEngine;
	
	CPlayerCharacter* m_pPC;
	
private:
	void CreateDevice();
	IrrlichtDevice* m_pDevice;  
	IVideoDriver* m_pDriver;
	ISceneManager* m_pSceneManager;
    IGUIEnvironment* m_pGUIEnvironment; //irrlichts default gui environment
	IFileSystem* m_FS;
	stringc m_WorkingDirectory;

	//CGameGUI* m_pGuiManager; //our homemade gui manager
	CLevelManager* m_pLevelManager;
	CGameGUI* m_GameGUI;
	ITexture* m_MousePointerTexture;
	ITexture* m_MousePointerPickableDraggingTexture;
	ITexture* m_MousePointerActionTexture;
	/*irr::gui::IGUIFont* m_pFont;*/

	CGoToArrows* m_Arrows;
	
};
#endif

