/** 
 * \file Script.cpp
 * \brief CScript class is the boss. The manager. It creates 3D device (irrlicht of course),
 * creates GUI, and 3D environment so called Level Editor. Calls all the initialization functions and 
 * goes to the loop.
 * 
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
using namespace irr;
using namespace io;
#include "Script.h"
#include "GameManager.h"

/**
 * \brief Standard constructor.
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
CScript::CScript()
{
	
}

/**
 * \brief Standard destructor.
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
CScript::~CScript()
{
}

/**
 * \brief Initialization function. Loads script actions from given XML file.
 * \author Petar Bajic 
 * \date July, 21 2008.
 */
bool CScript::Init(CGameManager* gameMngr, IrrlichtDevice* device, stringc filename)
{
	m_GameManager = gameMngr;
	IFileSystem* fs = device->getFileSystem();
	IXMLReader* xml = fs->createXMLReader(filename.c_str());
	while(xml && xml->read())
	{
		switch(xml->getNodeType())
		{
		case EXN_ELEMENT:
			{
				if (stringw("ScriptActions") != xml->getNodeName())
				{
					stringw figo = xml->getNodeName();
					m_ListOfScriptActions.push_back(figo.c_str());
				}
			}
		}
	}
	return true;
}

stringw CScript::GetActionLine(TAction action)
{
	stringw script = "<";
	script += action.name;
	script += " target=\"";
	script += action.target;
	script += "\" attribute=\"";
	script += action.attribute;
	script += "\" value=\"";
	script += action.value;
	script += "\" />\n";
	return script;
}

/* Giant Script Switch statement. 
 * All possible game events are handled here (scripts are called if applicable).
 */
void CScript::OnEvent(SCRIPT_EVENT_TYPE event, stringw script_name, s32 id)
{
	switch(event)
	{
	case SCRIPT_EVENT_NONE:
		{
		}
		break;
	case SCRIPT_EVENT_ONCONTAINERCLICK:
		{
			//player clicked on container
			m_GameManager->getGameGUI()->DisplayContainerContent(id,
				m_GameManager->getDriver(), m_GameManager->getGUIEnvironment(), m_GameManager->getLevelManager());
		}
		break;
	case SCRIPT_EVENT_ONPICK:
		{
			//FindScript
			//double check if object is pickable
			if(m_GameManager->getLevelManager()->m_pLevels[m_GameManager->getLevelManager()->m_LevelIndex]->m_ListOfGameObjects[id]->isPickable)
			{
				//parse XML file for script?
				m_GameManager->getFS()->changeWorkingDirectoryTo("media/Scripts/Pickables");
				stringc xml_filename = script_name.c_str();
				bool startLoadingScriptAction = false;
				bool loadingAction = false;
				TScriptAction scriptAction;
				io::IXMLReader* xml = m_GameManager->getFS()->createXMLReader(xml_filename.c_str());
				while(xml && xml->read())
				{
					switch(xml->getNodeType())
					{
					case io::EXN_ELEMENT:
						{
							if (stringw("OnPick") == xml->getNodeName())
							{
								scriptAction.event.name = xml->getNodeName();
								scriptAction.event.target = xml->getAttributeValue(L"target");
								scriptAction.actions.clear();
								loadingAction = true;
							}
							else if (loadingAction)
							{
								TAction action;
								action.name = xml->getNodeName();
								action.target = xml->getAttributeValue(L"target");
								action.attribute = xml->getAttributeValue(L"attribute");
								action.value = xml->getAttributeValue(L"value");
								scriptAction.actions.push_back(action);
							}
						}
						break;
					case io::EXN_ELEMENT_END:
						{
							if (scriptAction.event.name == xml->getNodeName())
							{
								loadingAction = false;
							}
						}
						break;
					}
				}
				if (xml)
					xml->drop(); // don't forget to delete the xml reader

				//or load script actions on load level?

				//hmmmm

				//well, on pick definitly is not that often called, so we can do xml
				// but 
				//on approach, on leave, on move and others caled every other frame... I think not

				//can we make dualism? in loading scripts?

				//is it going to speed up loading of level?

				//scheck in the next episode of

				//script squad chronicles

				//If script exists, execute it:
				for(u32 i=0; i<scriptAction.actions.size(); i++)
				{
					ExecuteScriptAction(scriptAction.actions[i], false);
				}

				//back to working dir
				m_GameManager->backToWorkingDirectory();
			}
		}
		break;
	case SCRIPT_EVENT_ONDROP:
		{
		}
		break;
	case SCRIPT_EVENT_ONUSE:
		{
			//FindScript
			//double check if object is pickable
			//if(m_GameManager->getLevelManager()->m_pLevels[m_LevelIndex]->m_ListOfGameObjects[id]->isPickable)
			{
				//parse XML file for script?
				m_GameManager->getFS()->changeWorkingDirectoryTo("media/Scripts/Pickables");
				stringc xml_filename = script_name.c_str();
				bool startLoadingScriptAction = false;
				bool loadingAction = false;
				TScriptAction scriptAction;
				io::IXMLReader* xml = m_GameManager->getFS()->createXMLReader(xml_filename.c_str());
				while(xml && xml->read())
				{
					switch(xml->getNodeType())
					{
					case io::EXN_ELEMENT:
						{
							if (stringw("OnUse") == xml->getNodeName())
							{
								scriptAction.event.name = xml->getNodeName();
								scriptAction.event.target = xml->getAttributeValue(L"target");
								scriptAction.actions.clear();
								loadingAction = true;
							}
							else if (loadingAction)
							{
								TAction action;
								action.name = xml->getNodeName();
								action.target = xml->getAttributeValue(L"target");
								action.attribute = xml->getAttributeValue(L"attribute");
								action.value = xml->getAttributeValue(L"value");
								scriptAction.actions.push_back(action);
							}
						}
						break;
					case io::EXN_ELEMENT_END:
						{
							if (scriptAction.event.name == xml->getNodeName())
							{
								loadingAction = false;
							}
						}
						break;
					}
				}
				if (xml)
					xml->drop(); // don't forget to delete the xml reader

				//back to working dir
				m_GameManager->backToWorkingDirectory();

				//If script exists, execute it:
				if((s32)(scriptAction.actions.size()) > -1)
				{
					for(u32 i=0; i<scriptAction.actions.size(); i++)
					{
						ExecuteScriptAction(scriptAction.actions[i], true);
					}
				}
				else //this item doesn't have script action for event OnUse
				{
					//msg: This item can't be used like that
					m_GameManager->getGameGUI()->AddConsoleText(L"This item can't be used like that");
				}
			}
		}
		break;
	case SCRIPT_EVENT_ONUSEAGAINST:
		{
			//parse XML file for script?
			m_GameManager->getFS()->changeWorkingDirectoryTo("media/Scripts/Pickables");
			stringc xml_filename = script_name.c_str();
			bool startLoadingScriptAction = false;
			bool loadingAction = false;
			TScriptAction scriptAction;
			io::IXMLReader* xml = m_GameManager->getFS()->createXMLReader(xml_filename.c_str());
			while(xml && xml->read())
			{
				switch(xml->getNodeType())
				{
				case io::EXN_ELEMENT:
					{
						if (stringw("OnUseAgainst") == xml->getNodeName())
						{
							scriptAction.event.name = xml->getNodeName();
							scriptAction.event.target = xml->getAttributeValue(L"target");
							scriptAction.actions.clear();
							loadingAction = true;
						}
						else if (loadingAction)
						{
							TAction action;
							action.name = xml->getNodeName();
							action.target = xml->getAttributeValue(L"target");
							action.attribute = xml->getAttributeValue(L"attribute");
							action.value = xml->getAttributeValue(L"value");
							scriptAction.actions.push_back(action);
						}
					}
					break;
				case io::EXN_ELEMENT_END:
					{
						if (scriptAction.event.name == xml->getNodeName())
						{
							loadingAction = false;
						}
					}
					break;
				}
			}
			if (xml)
				xml->drop(); // don't forget to delete the xml reader

			//back to working dir
			m_GameManager->backToWorkingDirectory();

			//if clicked on the specified object
			if(scriptAction.event.target == stringw(id))
			{
				//If script exists, execute it:
				for(u32 i=0; i<scriptAction.actions.size(); i++)
				{
					ExecuteScriptAction(scriptAction.actions[i], true);
				}
			}
			else
			{
				//msg: This item can't be used with that object
				m_GameManager->getGameGUI()->AddConsoleText(L"This item can't be used with that object");
			}
		}
		break;
	case SCRIPT_EVENT_TRIGGER_ONCLICK:
		{
			//FindScript
			//double check if object is trigger
			if(m_GameManager->getLevelManager()->m_pLevels[m_GameManager->getLevelManager()->m_LevelIndex]->m_ListOfGameObjects[id]->isTrigger)
			{
				//parse XML file for script?
				m_GameManager->getFS()->changeWorkingDirectoryTo("media/Scripts/Static");
				stringc xml_filename = m_GameManager->getLevelManager()->m_pLevels[m_GameManager->getLevelManager()->m_LevelIndex]->m_ListOfGameObjects[id]->script.c_str();
				bool loadingAction = false;
				TScriptAction scriptAction;
				io::IXMLReader* xml = m_GameManager->getFS()->createXMLReader(xml_filename.c_str());
				while(xml && xml->read())
				{
					switch(xml->getNodeType())
					{
					case io::EXN_ELEMENT:
						{
							if (stringw("OnClick") == xml->getNodeName())
							{
								//loading onclick event for currnet state of the game object
								if (m_GameManager->getLevelManager()->m_pLevels[m_GameManager->getLevelManager()->m_LevelIndex]->m_ListOfGameObjects[id]->state == stringw(xml->getAttributeValue(L"state")))
								{
									scriptAction.event.name = xml->getNodeName();
									scriptAction.event.state = xml->getAttributeValue(L"state");
									scriptAction.actions.clear();
									loadingAction = true;
								}
							}
							else if (loadingAction)
							{
								TAction action;
								action.name = xml->getNodeName();
								action.target = xml->getAttributeValue(L"target");
								action.attribute = xml->getAttributeValue(L"attribute");
								action.value = xml->getAttributeValue(L"value");
								scriptAction.actions.push_back(action);
							}
						}
						break;
					case io::EXN_ELEMENT_END:
						{
							if (scriptAction.event.name == xml->getNodeName())
							{
								loadingAction = false;
							}
						}
						break;
					}
				}
				if (xml)
					xml->drop(); // don't forget to delete the xml reader

				//back to working dir
				m_GameManager->backToWorkingDirectory();

				//If script exists, execute it:
				for(u32 i=0; i<scriptAction.actions.size(); i++)
				{
					ExecuteScriptAction(scriptAction.actions[i], false);
				}
			}
		}
		break;
	}
}

/* Another Giant Script Switch statement. 
 * All script actions are decoded and executed here.
 */
void CScript::ExecuteScriptAction(TAction action, bool consumePickable)
{
	if(action.name == stringw(L"InfluenceAbility"))
	{
		if(action.target == stringw("player"))
		{
			//find the attribute:
			for(u32 i=0; i<m_GameManager->getPC()->m_ListOfAbilities.size(); i++)
			{
				if(action.attribute == m_GameManager->getPC()->m_ListOfAbilities[i].name)
				{
					stringc value = action.value.c_str();
					f32 fValue = 0;
					s32 intValue = 0;
					s32 hasdot = value.findFirst('.');
					bool isInteger = (hasdot == -1);
					if(isInteger)
					{
						sscanf(value.c_str(),"%d",&intValue);
					}
					else
					{
						sscanf(value.c_str(),"%f",&fValue);
					}

					//increase ability
					m_GameManager->getPC()->m_ListOfAbilities[i].value += intValue + (s32)fValue; //one of two is 0, so we can add them

					//update GUI
					if(m_GameManager->getPC()->m_ListOfAbilities[i].name == m_GameManager->getGameGUI()->healthBar->getName())
					{
						m_GameManager->getGameGUI()->healthBar->changeValueBy((s32)fValue + intValue); 
					}
				}
			}
		}
		else if (action.target == stringw("self"))
		{
		}
		else //target is id
		{
			stringc value = action.target.c_str();
		}
	}
	else if(action.name == stringw("Info"))
	{
		if(action.value != stringw(L""))
		{
			m_GameManager->getGameGUI()->AddConsoleText(action.value);
		}
	}
	else if(action.name == stringw("InfluenceState"))
	{
		if(action.target == stringw("player"))
		{
		}
		else if (action.target == stringw("self"))
		{
		}
		else //target is id
		{
			u32 id;
			swscanf(action.target.c_str(), L"%d", &id);
			m_GameManager->getLevelManager()->m_pLevels[m_GameManager->getLevelManager()->m_LevelIndex]->m_ListOfGameObjects[id]->state = action.value.c_str();
		}
	}
	else if(action.name == stringw("Disintegrate"))
	{
		if(action.target == stringw("player"))
		{
		}
		else if (action.target == stringw("self"))
		{
			if (consumePickable)
			{
				if(m_GameManager->getGameGUI()->m_bDraggingPickableItem)
				{
					m_GameManager->getGameGUI()->m_bDraggingPickableItem = false;
					m_GameManager->getGameGUI()->m_pDraggedPickableItem = 0;
				}
				else
				{
					if(m_GameManager->getGameGUI()->m_pDraggedPickableItem != 0)
					{
						m_GameManager->getGameGUI()->RemovePickableFromInventory(m_GameManager->getGameGUI()->m_pDraggedPickableItem->index);
					}
				}
			}
		}
		else //target is id
		{
			stringc value = action.target.c_str();
		}
	}
	else if(action.name == stringw("LeadToMap"))
	{
		m_GameManager->getLevelManager()->OnLoadMap(stringc(action.value.c_str()).c_str());
	}
	else if(action.name == stringw("SetDialogNodeEnabled"))
	{
		bool enabled = false;
		if(action.value == stringw(L"true"))
		{
			enabled = true;
		}
		stringc nodeIDstr = action.target.c_str();
		m_GameManager->getGameGUI()->getDialogManager()->SetDialogNodeEnabled(action.attribute,atoi(nodeIDstr.c_str()),enabled);
	}
	else
	{
		m_GameManager->getGameGUI()->AddConsoleText(L"Unrecognized script action...");
	}
}