/** 
 * \file GameGUI.h
 * \brief Header file containing CGameGUI class used for managing GUI action.
 * CGameGUI class creates windows and interface and buttons and sprites 
 * and handles all the user clicks on them.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_GameGUICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_GameGUICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_

#include <irrlicht.h>
#include "CGUIContainer.h"
#include "CGUIBar.h"
#include "CDialogWindow.h"

class CGameManager;
class CLevelManager;

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

/**
 * \brief TGameObjectProperty is struct describing game object properties.
 * Standard irrlicht scene node attributes are expanded with few properties like: isContainer, isPickable...
 * \author Petar Bajic \date July, 21 2008.
 */
typedef struct S_GameObjectProperty
{
	stringw name;
	stringw mesh;
	stringw position;
	bool isContainer;
	bool isVisible;
	u32 id;

} TGameObjectProperty;

#define GAME_CONST_CONTAINER_ID 1357
#define GAME_CONST_INVENTORY_ID 1358

/**
 * \brief CGameGUI class creates windows and interface and buttons and sprites.
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CGameGUI
{
public:
	CGameGUI();
	~CGameGUI();
	bool Init(CGameManager* edMngr);
	//void SetIconAtHand(stringw parent, stringw name);
	bool OnEvent(const SEvent& event);
	void DisplayContainerContent(s32 id, IVideoDriver* driver, IGUIEnvironment* env, CLevelManager* levelManager);
	void DisplayOptionsWindow(IGUIEnvironment* env);
	void DisplayCharacterSheetWindow(IGUIEnvironment* env);
	bool InventoryFull() {return m_Inventory->isFull();}
	void AddConsoleText(stringw text);
	void AddPickableToInventory(stringw item_name);
	void RemovePickableFromInventory(s32 index);
	void StartNPCDialog(stringw dlgFilename);

	CDialogWindow* getDialogManager() { return m_DialogWindow;}

	CGameManager* m_GameManager;

	bool m_bDraggingPickableItem;
	CPickableItem* m_pDraggedPickableItem;
	CGUIBar* healthBar;

	CGUIBar* cs_ability_bars[10];
	CGUIBar* cs_skill_bars[10];
	CDialogWindow* m_DialogWindow;
	IGUIWindow* m_wnd_charSheet;

private:

	//IGUIWindow* m_wnd_gameItems;
	IGUIWindow* m_wnd_containerContent;
	IGUIWindow* m_wnd_options;
	IGUIContainer* m_Inventory;
	IGUIEditBox* m_Console;
	s32 m_ContainerID;
	s32 m_ActiveDialogIndex;
	IGUIButton* m_ContainerTakeAllButton;
	IGUIButton* m_SettingsButton;
	IGUIButton* m_CSheetButton;
	IGUIButton* m_ExitButton;
};

#endif

