/** 
 * \file PlayerCharacter.h
 * \brief Header file containing CPlayerCharacter class.
 * CPlayerCharacter class manages player state and action.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
#include "CCharacter.h"

class CGameManager;

using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

typedef struct S_Ability
{
	stringw name;
	s32 value;
	s32 min;
	s32 max;
} TAbility;

typedef struct S_Skill
{
	stringw name;
	s32 value;
	s32 min;
	s32 max;
} TSkill;

class CPlayerCharacter : public CCharacter
{
public:

	CPlayerCharacter(CGameManager* gm);
	~CPlayerCharacter();
	bool Load(IrrlichtDevice* device, ISceneManager *smgr, const c8* xmlPath);
	bool ReinitModel(irr::scene::ISceneManager *smgr);
	bool Save();
	void SetLoadedPosition();
	bool ReadXMLAttributes(IFileSystem* fs, stringc xml_filename);
	bool isAlive() {return m_bIsAlive;}
	void Dies() {m_bIsAlive = false;}
	void virtual notifyMoveEnd();
	void addAnimator(ITriangleSelector* selector);
	void removeAnimators();

	array<TAbility> m_ListOfAbilities;
	array<TSkill> m_ListOfSkills;
	CGameManager* m_GameManager;
	stringw m_MeshFilename;
	stringw m_Name;
	vector3df m_LoadedPosition;
	vector3df m_LoadedRotation;
	bool isInvisible;
	bool m_bIsAlive;
	u32 id;

	//Inventory!!
};