/** 
 * \file GameObject.h
 * \brief Header file containing CGameObject class used for storing Game object attributes and data.
 * CGameObject class handles mesh name and id, list of pickable items (if the object is container), etc...
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_GAMEOBJETIONS_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_GAMEOBJETIONS_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_

#include <irrlicht.h>
#include "../Script.h"

using namespace irr;
using namespace core;
using namespace video;
using namespace io;

/**
 * \brief TAnimationRanges is struct describing animated object animation frames.
 * Animated character usually has standard animations like Walk, Idle, Attack, Run, Sleep...
 * \author Petar Bajic \date July, 21 2008.
 */
typedef struct S_AnimationRanges
{
	u32 startFrame;
	u32 endFrame;
	stringw animName;

	//structs can have functions in C++! Yeey!
	void init() {
		startFrame = 0;
		endFrame = 0;
		animName = "";
	}

} TAnimationRange;

/**
 * \brief CGameObject class is describing game object properties.
 * Standard irrlicht scene node attributes are expanded with few properties like: isContainer, isPickable...
 * \author Petar Bajic \date July, 21 2008.
 */

class CGameObject
{
public:

	CGameObject();
	CGameObject(IXMLReader* xml, IVideoDriver* driver);
	CGameObject(stringw _root, s32 _id, IXMLReader* xml, IVideoDriver* driver);
	~CGameObject();
	void LoadPropertiesFromXMLFile(IXMLReader* xml);
	void AddPickableItem(CGameObject* pick);
	CGameObject* GetPickableItem(s32 id);
	stringw GetPickableItemRoot(s32 id);
	s32 GetPickableItemID(s32 id);

	void ClearPickableItems();
	s32 GetNumberOfPickableItems();
	void ClearScriptActions();

	int getAnimStart(stringw name)
	{
		list<TAnimationRange>::Iterator it = animations.begin();
		
		for (; it != animations.end(); ++it)
		{
			if((*it).animName == name)
			{
				return (*it).startFrame;
			}
		}

		return 0;
	}

	int getAnimEnd(stringw name)
	{
		list<TAnimationRange>::Iterator it = animations.begin();
		
		for (; it != animations.end(); ++it)
		{
			if((*it).animName == name)
			{
				return (*it).endFrame;
			}
		}

		return 0;
	}

	stringw name;
	stringw mesh;
	vector3d<f32> pos;
	vector3d<f32> rot;
	vector3d<f32> scale;
	bool isInvisible;
	bool isPickable;
	bool isTrigger;
	bool isStatic;
	bool isNPC;
	bool isMonster;
	bool isContainer;
	bool isAnimated;
	bool isAnchored;
	bool isTerrain;
	stringw description;
	stringw script;
	stringw state;
	stringw icon;
	stringw root;
	list <TAnimationRange> animations;
	ITexture* m_IconTexture;
	//only container objects have this list to asociate them to pickable items they contain
	array <CGameObject*> m_ListOfPickableItems;
	array <TScriptAction> m_ListOfScriptActions;
	s32 id;

	IVideoDriver* m_Driver;
};

#endif
