/** 
 * \file Level.h
 * \brief Header file containing CLevel class that is game level.
 * CLevel class manages game objects on the map.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#include <irrlicht.h>
#include "GameObject.h"
using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CLevel 
{
public:

	CLevel();
	~CLevel();
	bool Init(IrrlichtDevice* device, IFileSystem* fs, IVideoDriver* driver, ISceneManager* smgr);
	bool Load(stringc map_filename);
	void Save(stringc map);
	void addTerrainSelector();
	//s32 OnMouseClick();

	/* ISceneUserDataSerializer functions: */
	vector3df GetStartPosition();
	void ReadSceneNode(IXMLReader* reader);
	void WriteSceneNode(IXMLWriter* writer, ISceneNode* node);
	CGameObject* createPickableGameObject(stringw rootName, s32 id);
	void RemoveContainerContent(int containerID);
	bool EraseElement(int id);
	void AddContainerItem(int containerID, CGameObject* pick);
	int GetContainerNumberOfItems(int containerID);
	CGameObject* GetContainerItem(int containerID, int itemID);
	bool isActionItemUnderMousePointer(position2d<s32> mousePos);
	CGameObject* getClickedGameObject(position2d<s32> mousePos);
	bool isObjectContainer(int id);
	bool isObjectPickable(int id);
	bool isObjectTrigger(int id);
	bool isObjectNPC(int id);
	bool isObjectMonster(int id);
	stringw GetObjectScript(int id);
	void SetObjectState(int id, stringw state);
	stringw GetObjectState(int id);
	vector3df GetObjectPosition(int id);
	void AddObjectToScene(CGameObject* pick, vector3df position);

	stringw GetRootFromPath(stringw path);

	IFileSystem* m_pFS;
	IVideoDriver* m_pDriver;
	ISceneManager* m_SMGR;
	IrrlichtDevice* m_pDevice;
	stringc m_LoadingDir;
	stringc m_MapName;
	s32 m_ID;
	vector3df m_startPos;
	//array of game objects on this level
	list <CGameObject*> m_ListOfGameObjects;
	IMetaTriangleSelector* m_LevelMetaTriangleSelector; //used for clicking reaction for all objects on the map
	IMetaTriangleSelector* m_ObstacleMetaTriangleSelector; //used for collision with static objects

	CGameObject* getGameObjectFromID(int id);

};