/** 
 * \file LevelManager.h
 * \brief Header file containing CLevelManager class used for managing game levels.
 * CLevelManager class handles saving and loading maps, and handles map related user events.
 *
 * \author Petar Bajic, MPE (C) All Rights Reserved, Homepage: www.mystic-peanut.com
 * \date July, 21 2008.
 */

#if !defined(AFX_EDLEVELICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_EDLEVELICA_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_


#include <irrlicht.h>
//#include "../gui/GameGUI.h"
#include "RTSCamera.h"
#include "Level.h"
#include "../GameManager.h"
using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

class CGameManager;
class CGameGUI;

/**
 * \brief CLevelManager class manages 3D game objects.
 *
 * It takes care of saving/loading levels 
 * manages game object arrays (adding deleting game objects)
 * allows translation, rotation and scaling of models.
 * implements undo/redo functionality
 * translates events to game objects -> on mouse click, on rotate etc..
 * tightly communicates with GUI environment, for example: 
 *  - selecting different game object causes changes in GUI window Properties
 *  - changed game object properties must be saved to map file
 *
 * \author Petar Bajic \date July, 21 2008.
 */
class CLevelManager// : public ISceneUserDataSerializer 
{
public:
	CLevelManager();
	~CLevelManager();
	bool Init(CGameManager* gameMngr, CGameGUI* gameGUI);
	bool OnEvent(const SEvent& event);
	bool OnLoadMap(stringc map_filename);
	void SaveLevels();
	void SavePreviousLevelToTemp();
	void CreateCamera(vector3df position);
	void SetCameraPos(vector3df position);
	vector3df GetStartPosition();
	//bool SetElementAtHand(stringc filename, TGameObjectProperty properties);
	//bool SingleObjectSelected();
	void OnRender();
	/* ISceneUserDataSerializer functions: */
	//IAttributes* createUserData (irr::scene::ISceneNode *forSceneNode);
	//void OnReadUserData (irr::scene::ISceneNode *forSceneNode, irr::io::IAttributes *userData);

	void  RemoveContainerContent(int containerID);
	void  AddContainerItem(int containerID, CGameObject* pick);
	int GetContainerNumberOfItems(int containerID);
	CGameObject* GetContainerItem(int containerID, int itemID);
	IMetaTriangleSelector* GetLevelMetaTriangleSelector() { return m_pLevels[m_LevelIndex]->m_LevelMetaTriangleSelector;}
	IMetaTriangleSelector* GetObstacleMetaTriangleSelector() { return m_pLevels[m_LevelIndex]->m_ObstacleMetaTriangleSelector;}
	bool isNodeTerrain(const ISceneNode* node);
	bool isNodeActionObject(const ISceneNode* node);
	bool isObjectContainer(int id);
	bool isObjectPickable(int id);
	bool isObjectTrigger(int id);
	bool isObjectNPC(int id);
	bool isObjectMonster(int id);
	bool Action(s32 id);
	stringw GetObjectScript(int id);
	void SetObjectState(int id, stringw state);
	stringw GetObjectState(int id);
	vector3df GetObjectPosition(int id);
	CGameObject* getGameObjectFromID(int id);
	void MoveCamera(vector3df pos);
	void DropPickableToMap(CGameObject* pick, vector3df position);
	stringw getCurrentMapName();
	u32 _GetLevelIndex(stringc map_filename);
	u32 FindNPCsOnMap(stringc mapname, stringc NPCNames[]);

	CGameManager* m_GameManager;
	CGameGUI* m_GameGUI;
	CLevel* m_pLevels[MAX_NUMBER_OF_LEVELS];
	s32 m_LevelIndex;
	//we need list of game objects here
	//ISceneNode* m_SelectedGameObject;
	//bool m_bMoveSelectedNode;
	bool m_bMoveToPosition;
	bool m_bShiftPressed;
	bool m_bHoverOverActionItem;
	bool m_DeletePicked;
	u32 m_NumberOfLoadedLevels;

	//bool m_bRotateSelectedNode;
	//s32 m_NodeRotationX;
	//core::array <CGameObject*> m_ListOfGameObjects;
	RTSCamera* m_pCamera;
	vector3df m_CurrentZoom;
	//vector3df m_CurrentRotationOfSelectedNode;
	vector3df m_instersection_point;
	//vector3df m_selectedGameObjectStartMovingPosition;
};

#endif